package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSIDriverSpecBuilder extends CSIDriverSpecFluentImpl<CSIDriverSpecBuilder> implements VisitableBuilder<CSIDriverSpec,CSIDriverSpecBuilder> {

    CSIDriverSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CSIDriverSpecBuilder() {
        this(true);
    }

    public CSIDriverSpecBuilder(Boolean validationEnabled) {
        this(new CSIDriverSpec(), validationEnabled);
    }

    public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CSIDriverSpec(), validationEnabled);
    }

    public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent,CSIDriverSpec instance) {
        this(fluent, instance, true);
    }

    public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent,CSIDriverSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAttachRequired(instance.getAttachRequired()); 
        fluent.withFsGroupPolicy(instance.getFsGroupPolicy()); 
        fluent.withPodInfoOnMount(instance.getPodInfoOnMount()); 
        fluent.withRequiresRepublish(instance.getRequiresRepublish()); 
        fluent.withStorageCapacity(instance.getStorageCapacity()); 
        fluent.withTokenRequests(instance.getTokenRequests()); 
        fluent.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIDriverSpecBuilder(CSIDriverSpec instance) {
        this(instance,true);
    }

    public CSIDriverSpecBuilder(CSIDriverSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAttachRequired(instance.getAttachRequired()); 
        this.withFsGroupPolicy(instance.getFsGroupPolicy()); 
        this.withPodInfoOnMount(instance.getPodInfoOnMount()); 
        this.withRequiresRepublish(instance.getRequiresRepublish()); 
        this.withStorageCapacity(instance.getStorageCapacity()); 
        this.withTokenRequests(instance.getTokenRequests()); 
        this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIDriverSpec build() {
        CSIDriverSpec buildable = new CSIDriverSpec(fluent.getAttachRequired(),fluent.getFsGroupPolicy(),fluent.getPodInfoOnMount(),fluent.getRequiresRepublish(),fluent.getStorageCapacity(),fluent.getTokenRequests(),fluent.getVolumeLifecycleModes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSIDriverSpecBuilder that = (CSIDriverSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
