package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TokenRequestBuilder extends TokenRequestFluentImpl<TokenRequestBuilder> implements VisitableBuilder<TokenRequest,TokenRequestBuilder> {

    TokenRequestFluent<?> fluent;
    Boolean validationEnabled;

    public TokenRequestBuilder() {
        this(true);
    }

    public TokenRequestBuilder(Boolean validationEnabled) {
        this(new TokenRequest(), validationEnabled);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent) {
        this(fluent, true);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TokenRequest(), validationEnabled);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent,TokenRequest instance) {
        this(fluent, instance, true);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent,TokenRequest instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAudience(instance.getAudience()); 
        fluent.withExpirationSeconds(instance.getExpirationSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenRequestBuilder(TokenRequest instance) {
        this(instance,true);
    }

    public TokenRequestBuilder(TokenRequest instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAudience(instance.getAudience()); 
        this.withExpirationSeconds(instance.getExpirationSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenRequest build() {
        TokenRequest buildable = new TokenRequest(fluent.getAudience(),fluent.getExpirationSeconds());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TokenRequestBuilder that = (TokenRequestBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
