/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.constants;

import io.neow3j.crypto.Hash;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.nio.charset.StandardCharsets;

public enum InteropServiceCode {
    SYSTEM_BINARY_SERIALIZE("System.Binary.Serialize", 4096),
    SYSTEM_BINARY_DESERIALIZE("System.Binary.Deserialize", 16384),
    SYSTEM_BINARY_BASE64ENCODE("System.Binary.Base64Encode", 4096),
    SYSTEM_BINARY_BASE64DECODE("System.Binary.Base64Decode", 4096),
    SYSTEM_BINARY_BASE58ENCODE("System.Binary.Base58Encode", 4096),
    SYSTEM_BINARY_BASE58DECODE("System.Binary.Base58Decode", 4096),
    SYSTEM_BINARY_ITOA("System.Binary.Itoa", 4096),
    SYSTEM_BINARY_ATOI("System.Binary.Atoi", 4096),
    SYSTEM_CONTRACT_CALL("System.Contract.Call", 32768),
    SYSTEM_CONTRACT_CALLNATIVE("System.Contract.CallNative", 0),
    SYSTEM_CONTRACT_ISSTANDARD("System.Contract.IsStandard", 1024),
    SYSTEM_CONTRACT_GETCALLFLAGS("System.Contract.GetCallFlags", 1024),
    SYSTEM_CONTRACT_CREATESTANDARDACCOUNT("System.Contract.CreateStandardAccount", 256),
    SYSTEM_CONTRACT_NATIVEONPERSIST("System.Contract.NativeOnPersist", 0),
    SYSTEM_CONTRACT_NATIVEPOSTPERSIST("System.Contract.NativePostPersist", 0),
    NEO_CRYPTO_RIPEMD160("Neo.Crypto.RIPEMD160", 32768),
    NEO_CRYPTO_SHA256("Neo.Crypto.SHA256", 32768),
    NEO_CRYPTO_VERIFYWITHECDSASECP256R1("Neo.Crypto.VerifyWithECDsaSecp256r1", 32768),
    NEO_CRYPTO_VERIFYWITHECDSASECP256K1("Neo.Crypto.VerifyWithECDsaSecp256k1", 32768),
    NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256R1("Neo.Crypto.CheckMultisigWithECDsaSecp256r1", 0),
    NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256K1("Neo.Crypto.CheckMultisigWithECDsaSecp256k1", 0),
    SYSTEM_ITERATOR_CREATE("System.Iterator.Create", 16),
    SYSTEM_ITERATOR_NEXT("System.Iterator.Next", 32768),
    SYSTEM_ITERATOR_VALUE("System.Iterator.Value", 16),
    SYSTEM_JSON_SERIALIZE("System.Json.Serialize", 4096),
    SYSTEM_JSON_DESERIALIZE("System.Json.Deserialize", 16384),
    SYSTEM_RUNTIME_PLATFORM("System.Runtime.Platform", 8),
    SYSTEM_RUNTIME_GETTRIGGER("System.Runtime.GetTrigger", 8),
    SYSTEM_RUNTIME_GETTIME("System.Runtime.GetTime", 8),
    SYSTEM_RUNTIME_GETSCRIPTCONTAINER("System.Runtime.GetScriptContainer", 8),
    SYSTEM_RUNTIME_GETEXECUTINGSCRIPTHASH("System.Runtime.GetExecutingScriptHash", 16),
    SYSTEM_RUNTIME_GETCALLINGSCRIPTHASH("System.Runtime.GetCallingScriptHash", 16),
    SYSTEM_RUNTIME_GETENTRYSCRIPTHASH("System.Runtime.GetEntryScriptHash", 16),
    SYSTEM_RUNTIME_CHECKWITNESS("System.Runtime.CheckWitness", 1024),
    SYSTEM_RUNTIME_GETINVOCATIONCOUNTER("System.Runtime.GetInvocationCounter", 16),
    SYSTEM_RUNTIME_LOG("System.Runtime.Log", 32768),
    SYSTEM_RUNTIME_NOTIFY("System.Runtime.Notify", 32768),
    SYSTEM_RUNTIME_GETNOTIFICATIONS("System.Runtime.GetNotifications", 256),
    SYSTEM_RUNTIME_GASLEFT("System.Runtime.GasLeft", 16),
    SYSTEM_STORAGE_GETCONTEXT("System.Storage.GetContext", 16),
    SYSTEM_STORAGE_GETREADONLYCONTEXT("System.Storage.GetReadOnlyContext", 16),
    SYSTEM_STORAGE_ASREADONLY("System.Storage.AsReadOnly", 16),
    SYSTEM_STORAGE_GET("System.Storage.Get", 32768),
    SYSTEM_STORAGE_FIND("System.Storage.Find", 32768),
    SYSTEM_STORAGE_PUT("System.Storage.Put", 0),
    SYSTEM_STORAGE_PUTEX("System.Storage.PutEx", 0),
    SYSTEM_STORAGE_DELETE("System.Storage.Delete", 0);

    private String name;
    private Long price;

    private InteropServiceCode(String name, Integer price) {
        this.name = name;
        if (price != null) {
            this.price = (long)price;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHash() {
        byte[] sha256 = Hash.sha256(this.getName().getBytes(StandardCharsets.US_ASCII));
        return Numeric.toHexStringNoPrefix(ArrayUtils.getFirstNBytes(sha256, 4));
    }

    public long getPrice() {
        switch (this) {
            case NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256R1: 
            case NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256K1: {
                throw new UnsupportedOperationException("The price of the interop service " + this.getName() + " is not fixed but depends on the number of signatures.");
            }
        }
        return this.price;
    }

    public long getPrice(int param) {
        if (this.price != null) {
            return this.price;
        }
        switch (this) {
            case NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256R1: {
                return (long)param * InteropServiceCode.NEO_CRYPTO_VERIFYWITHECDSASECP256R1.price;
            }
            case NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256K1: {
                return (long)param * InteropServiceCode.NEO_CRYPTO_VERIFYWITHECDSASECP256K1.price;
            }
        }
        throw new UnsupportedOperationException("The price for " + this.toString() + " is not defined.");
    }

    public String toString() {
        return this.getName();
    }
}

