/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.constants;

import io.neow3j.constants.OperandSize;
import io.neow3j.utils.Numeric;
import java.lang.annotation.Annotation;

public enum OpCode {
    PUSHINT8(0, 1),
    PUSHINT16(1, 1),
    PUSHINT32(2, 1),
    PUSHINT64(3, 1),
    PUSHINT128(4, 4),
    PUSHINT256(5, 4),
    PUSHA(10, 4),
    PUSHNULL(11, 1),
    PUSHDATA1(12, 8),
    PUSHDATA2(13, 512),
    PUSHDATA4(14, 4096),
    PUSHM1(15, 1),
    PUSH0(16, 1),
    PUSH1(17, 1),
    PUSH2(18, 1),
    PUSH3(19, 1),
    PUSH4(20, 1),
    PUSH5(21, 1),
    PUSH6(22, 1),
    PUSH7(23, 1),
    PUSH8(24, 1),
    PUSH9(25, 1),
    PUSH10(26, 1),
    PUSH11(27, 1),
    PUSH12(28, 1),
    PUSH13(29, 1),
    PUSH14(30, 1),
    PUSH15(31, 1),
    PUSH16(32, 1),
    NOP(33, 1),
    JMP(34, 2),
    JMP_L(35, 2),
    JMPIF(36, 2),
    JMPIF_L(37, 2),
    JMPIFNOT(38, 2),
    JMPIFNOT_L(39, 2),
    JMPEQ(40, 2),
    JMPEQ_L(41, 2),
    JMPNE(42, 2),
    JMPNE_L(43, 2),
    JMPGT(44, 2),
    JMPGT_L(45, 2),
    JMPGE(46, 2),
    JMPGE_L(47, 2),
    JMPLT(48, 2),
    JMPLT_L(49, 2),
    JMPLE(50, 2),
    JMPLE_L(51, 2),
    CALL(52, 512),
    CALL_L(53, 512),
    CALLA(54, 512),
    CALLT(55, 32768),
    ABORT(56, 0),
    ASSERT(57, 1),
    THROW(58, 512),
    TRY(59, 4),
    TRY_L(60, 4),
    ENDTRY(61, 4),
    ENDTRY_L(62, 4),
    ENDFINALLY(63, 4),
    RET(64, 0),
    SYSCALL(65, 0),
    DEPTH(67, 2),
    DROP(69, 2),
    NIP(70, 2),
    XDROP(72, 16),
    CLEAR(73, 16),
    DUP(74, 2),
    OVER(75, 2),
    PICK(77, 2),
    TUCK(78, 2),
    SWAP(80, 2),
    ROT(81, 2),
    ROLL(82, 16),
    REVERSE3(83, 2),
    REVERSE4(84, 2),
    REVERSEN(85, 16),
    INITSSLOT(86, 16),
    INITSLOT(87, 64),
    LDSFLD0(88, 2),
    LDSFLD1(89, 2),
    LDSFLD2(90, 2),
    LDSFLD3(91, 2),
    LDSFLD4(92, 2),
    LDSFLD5(93, 2),
    LDSFLD6(94, 2),
    LDSFLD(95, 2),
    STSFLD0(96, 2),
    STSFLD1(97, 2),
    STSFLD2(98, 2),
    STSFLD3(99, 2),
    STSFLD4(100, 2),
    STSFLD5(101, 2),
    STSFLD6(102, 2),
    STSFLD(103, 2),
    LDLOC0(104, 2),
    LDLOC1(105, 2),
    LDLOC2(106, 2),
    LDLOC3(107, 2),
    LDLOC4(108, 2),
    LDLOC5(109, 2),
    LDLOC6(110, 2),
    LDLOC(111, 2),
    STLOC0(112, 2),
    STLOC1(113, 2),
    STLOC2(114, 2),
    STLOC3(115, 2),
    STLOC4(116, 2),
    STLOC5(117, 2),
    STLOC6(118, 2),
    STLOC(119, 2),
    LDARG0(120, 2),
    LDARG1(121, 2),
    LDARG2(122, 2),
    LDARG3(123, 2),
    LDARG4(124, 2),
    LDARG5(125, 2),
    LDARG6(126, 2),
    LDARG(127, 2),
    STARG0(128, 2),
    STARG1(129, 2),
    STARG2(130, 2),
    STARG3(131, 2),
    STARG4(132, 2),
    STARG5(133, 2),
    STARG6(134, 2),
    STARG(135, 2),
    NEWBUFFER(136, 256),
    MEMCPY(137, 2048),
    CAT(139, 2048),
    SUBSTR(140, 2048),
    LEFT(141, 2048),
    RIGHT(142, 2048),
    INVERT(144, 4),
    AND(145, 8),
    OR(146, 8),
    XOR(147, 8),
    EQUAL(151, 32),
    NOTEQUAL(152, 32),
    SIGN(153, 4),
    ABS(154, 4),
    NEGATE(155, 4),
    INC(156, 4),
    DEC(157, 4),
    ADD(158, 8),
    SUB(159, 8),
    MUL(160, 8),
    DIV(161, 8),
    MOD(162, 8),
    SHL(168, 8),
    SHR(169, 8),
    NOT(170, 4),
    BOOLAND(171, 8),
    BOOLOR(172, 8),
    NZ(177, 4),
    NUMEQUAL(179, 8),
    NUMNOTEQUAL(180, 8),
    LT(181, 8),
    LE(182, 8),
    GT(183, 8),
    GE(184, 8),
    MIN(185, 8),
    MAX(186, 8),
    WITHIN(187, 8),
    PACK(192, 512),
    UNPACK(193, 512),
    NEWARRAY0(194, 16),
    NEWARRAY(195, 512),
    NEWARRAY_T(196, 512),
    NEWSTRUCT0(197, 16),
    NEWSTRUCT(198, 512),
    NEWMAP(200, 8),
    SIZE(202, 4),
    HASKEY(203, 64),
    KEYS(204, 16),
    VALUES(205, 8192),
    PICKITEM(206, 64),
    APPEND(207, 8192),
    SETITEM(208, 8192),
    REVERSEITEMS(209, 8192),
    REMOVE(210, 16),
    CLEARITEMS(211, 16),
    ISNULL(216, 2),
    ISTYPE(217, 2),
    CONVERT(219, 2048);

    private int opcode;
    private Long price;
    private static OpCode[] opcodes;

    private OpCode(int opcode, int price) {
        this.opcode = opcode;
        this.price = price;
    }

    public int getCode() {
        return this.opcode;
    }

    public long getPrice() {
        return this.price;
    }

    public static OpCode get(byte opcode) {
        return OpCode.get(Byte.toUnsignedInt(opcode));
    }

    public static OpCode get(int opcode) {
        if (opcode < 0 || opcode > 219) {
            return null;
        }
        return opcodes[opcode];
    }

    public static OpCode valueOf(byte code) {
        for (OpCode c : OpCode.values()) {
            if (c.opcode != code) continue;
            return c;
        }
        throw new IllegalArgumentException("No Opcode found for byte value " + Numeric.toHexString(code) + ".");
    }

    public String toString() {
        return Numeric.toHexStringNoPrefix((byte)this.getCode());
    }

    public static OperandSize getOperandSize(OpCode code) {
        try {
            Annotation[] annotations = OpCode.class.getField(code.name()).getAnnotations();
            if (annotations.length == 0) {
                return null;
            }
            if (annotations[0].annotationType() != OperandSize.class) {
                throw new IllegalStateException("Unsupported annotation on OpCode.");
            }
            return (OperandSize)annotations[0];
        }
        catch (NoSuchFieldException ignore) {
            return null;
        }
    }

    static {
        opcodes = new OpCode[220];
        OpCode[] opCodeArray = OpCode.values();
        int n = opCodeArray.length;
        for (int i = 0; i < n; ++i) {
            OpCode code;
            OpCode.opcodes[code.opcode] = code = opCodeArray[i];
        }
    }
}

