/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.neow3j.contract.ScriptHash;
import io.neow3j.crypto.Base64;
import io.neow3j.model.types.ContractParameterType;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonSerialize(using=ContractParameterSerializer.class)
@JsonDeserialize(using=ContractParameterDeserializer.class)
public class ContractParameter {
    @JsonProperty(value="name")
    private String paramName;
    @JsonProperty(value="type")
    private ContractParameterType paramType;
    @JsonProperty(value="value")
    protected Object value;

    private ContractParameter() {
    }

    public ContractParameter(String name, ContractParameterType paramType, Object value) {
        this.paramName = name;
        this.paramType = paramType;
        this.value = value;
    }

    ContractParameter(String name, ContractParameterType paramType) {
        this(name, paramType, null);
    }

    private ContractParameter(ContractParameterType paramType, Object value) {
        this(null, paramType, value);
    }

    public static ContractParameter any(Object value) {
        return new ContractParameter(ContractParameterType.ANY, value);
    }

    public static ContractParameter string(String value) {
        return new ContractParameter(ContractParameterType.STRING, value);
    }

    public static ContractParameter array(Object ... value) {
        ArrayList<ContractParameter> params = new ArrayList<ContractParameter>();
        Arrays.stream(value).forEach(o -> {
            if (o instanceof ContractParameter) {
                params.add((ContractParameter)o);
            } else if (o instanceof Boolean) {
                params.add(ContractParameter.bool((Boolean)o));
            } else if (o instanceof Integer) {
                params.add(ContractParameter.integer((Integer)o));
            } else if (o instanceof byte[]) {
                params.add(ContractParameter.byteArray((byte[])o));
            } else if (o instanceof String) {
                params.add(ContractParameter.string((String)o));
            } else {
                throw new IllegalArgumentException("The provided object could not be casted into a supported contract parameter type.");
            }
        });
        return ContractParameter.array(params);
    }

    public static ContractParameter array(List<ContractParameter> params) {
        return ContractParameter.array(params.toArray(new ContractParameter[0]));
    }

    public static ContractParameter array(ContractParameter ... params) {
        if (params.length == 0) {
            throw new IllegalArgumentException("At least one parameter is required to create an array contract parameter.");
        }
        boolean anyNull = Arrays.stream(params).anyMatch(Objects::isNull);
        if (anyNull) {
            throw new IllegalArgumentException("Cannot add a null object to an array contract parameter.");
        }
        return new ContractParameter(ContractParameterType.ARRAY, params);
    }

    public static ContractParameter byteArray(byte[] byteArray) {
        return new ContractParameter(ContractParameterType.BYTE_ARRAY, byteArray);
    }

    public static ContractParameter byteArray(String hexString) {
        if (!Numeric.isValidHexString(hexString)) {
            throw new IllegalArgumentException("Argument is not a valid hex number");
        }
        return ContractParameter.byteArray(Numeric.hexStringToByteArray(hexString));
    }

    public static ContractParameter byteArrayFromString(String value) {
        return ContractParameter.byteArray(value.getBytes(StandardCharsets.UTF_8));
    }

    public static ContractParameter signature(String signatureHexString) {
        if (!Numeric.isValidHexString(signatureHexString)) {
            throw new IllegalArgumentException("Argument is not a valid hex number");
        }
        return ContractParameter.signature(Numeric.hexStringToByteArray(signatureHexString));
    }

    public static ContractParameter signature(byte[] signature) {
        if (signature.length != 64) {
            throw new IllegalArgumentException("Signature is expected to have a length of 64 bytes, but had " + signature.length + ".");
        }
        return new ContractParameter(ContractParameterType.SIGNATURE, signature);
    }

    public static ContractParameter bool(boolean bool) {
        return new ContractParameter(ContractParameterType.BOOLEAN, bool);
    }

    public static ContractParameter integer(int integer) {
        return ContractParameter.integer(BigInteger.valueOf(integer));
    }

    public static ContractParameter integer(BigInteger integer) {
        return new ContractParameter(ContractParameterType.INTEGER, integer);
    }

    public static ContractParameter hash160(ScriptHash hash) {
        if (hash == null) {
            throw new IllegalArgumentException("The script hash argument must not be null.");
        }
        return new ContractParameter(ContractParameterType.HASH160, hash);
    }

    public static ContractParameter hash256(String hashHexString) {
        if (!Numeric.isValidHexString(hashHexString)) {
            throw new IllegalArgumentException("Argument is not a valid hex number");
        }
        return ContractParameter.hash256(Numeric.hexStringToByteArray(hashHexString));
    }

    public static ContractParameter hash256(byte[] hash) {
        if (hash.length != 32) {
            throw new IllegalArgumentException("A Hash256 parameter must be 32 bytes long but was " + hash.length + " bytes long.");
        }
        return new ContractParameter(ContractParameterType.HASH256, hash);
    }

    public static ContractParameter publicKey(String publicKey) {
        return ContractParameter.publicKey(Numeric.hexStringToByteArray(publicKey));
    }

    public static ContractParameter publicKey(byte[] publicKey) {
        if (publicKey.length != 33) {
            throw new IllegalArgumentException("Public key argument must be 33 long but was " + publicKey.length + " bytes");
        }
        return new ContractParameter(ContractParameterType.PUBLIC_KEY, publicKey);
    }

    public String getParamName() {
        return this.paramName;
    }

    public ContractParameterType getParamType() {
        return this.paramType;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractParameter)) {
            return false;
        }
        ContractParameter that = (ContractParameter)o;
        if (this.paramType == that.paramType && Objects.equals(this.paramName, that.paramName)) {
            if (this.paramType.equals((Object)ContractParameterType.BYTE_ARRAY) || this.paramType.equals((Object)ContractParameterType.SIGNATURE) || this.paramType.equals((Object)ContractParameterType.PUBLIC_KEY) || this.paramType.equals((Object)ContractParameterType.HASH160) || this.paramType.equals((Object)ContractParameterType.HASH256)) {
                return Arrays.equals((byte[])this.value, (byte[])that.value);
            }
            if (this.paramType.equals((Object)ContractParameterType.ARRAY)) {
                Object[] thatValue = (ContractParameter[])that.getValue();
                Object[] oValue = (ContractParameter[])((ContractParameter)o).getValue();
                return Arrays.equals(oValue, thatValue);
            }
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paramName, this.paramType, this.value});
    }

    protected static abstract class ParameterDeserializer<T extends ContractParameter>
    extends StdDeserializer<T> {
        public ParameterDeserializer() {
            this(null);
        }

        public ParameterDeserializer(Class<T> vc) {
            super(vc);
        }

        public abstract T newInstance(String var1, ContractParameterType var2, Object var3);

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return this.deserializeParameter(node, jp);
        }

        private T deserializeParameter(JsonNode param, JsonParser jp) throws JsonProcessingException {
            JsonNode nameNode = param.get("name");
            String name = null;
            if (nameNode != null) {
                name = nameNode.asText();
            }
            JsonNode typeNode = param.get("type");
            ContractParameterType type = null;
            if (typeNode != null) {
                type = (ContractParameterType)((Object)jp.getCodec().treeToValue((TreeNode)typeNode, ContractParameterType.class));
            }
            JsonNode valueNode = param.get("value");
            Object value = null;
            if (valueNode != null) {
                value = this.deserializeValue(valueNode, type, jp);
            }
            return this.newInstance(name, type, value);
        }

        private Object deserializeValue(JsonNode value, ContractParameterType type, JsonParser jp) throws JsonProcessingException {
            switch (type) {
                case SIGNATURE: 
                case HASH256: 
                case PUBLIC_KEY: {
                    return Numeric.hexStringToByteArray(value.asText());
                }
                case BYTE_ARRAY: {
                    return Base64.decode(value.asText());
                }
                case STRING: {
                    return value.asText();
                }
                case BOOLEAN: {
                    return value.asBoolean();
                }
                case INTEGER: {
                    return new BigInteger(value.asText());
                }
                case HASH160: {
                    return new ScriptHash(value.asText());
                }
                case ARRAY: {
                    if (value.isArray()) {
                        ArrayList<T> arr = new ArrayList<T>(value.size());
                        for (JsonNode param : value) {
                            arr.add(this.deserializeParameter(param, jp));
                        }
                        return arr.toArray(new ContractParameter[0]);
                    }
                }
                case INTEROP_INTERFACE: {
                    return value.asText();
                }
            }
            throw new UnsupportedOperationException("Parameter type '" + (Object)((Object)type) + "' not supported.");
        }
    }

    protected static class ContractParameterDeserializer
    extends ParameterDeserializer<ContractParameter> {
        protected ContractParameterDeserializer() {
        }

        @Override
        public ContractParameter newInstance(String name, ContractParameterType type, Object value) {
            return new ContractParameter(name, type, value);
        }
    }

    protected static class ContractParameterSerializer
    extends StdSerializer<ContractParameter> {
        public ContractParameterSerializer() {
            this(null);
        }

        public ContractParameterSerializer(Class<ContractParameter> vc) {
            super(vc);
        }

        public void serialize(ContractParameter value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            this.serializeParameter(value, gen);
        }

        private void serializeParameter(ContractParameter p, JsonGenerator gen) throws IOException {
            gen.writeStartObject();
            if (p.getParamName() != null) {
                gen.writeStringField("name", p.getParamName());
            }
            if (p.getParamType() != null) {
                gen.writeStringField("type", p.getParamType().jsonValue());
            }
            if (p.getValue() != null) {
                this.serializeValue(p, gen);
            }
            gen.writeEndObject();
        }

        private void serializeValue(ContractParameter p, JsonGenerator gen) throws IOException {
            switch (p.getParamType()) {
                case SIGNATURE: 
                case HASH256: 
                case PUBLIC_KEY: {
                    gen.writeStringField("value", Numeric.toHexStringNoPrefix((byte[])p.getValue()));
                    break;
                }
                case BYTE_ARRAY: {
                    gen.writeStringField("value", Base64.encode((byte[])p.getValue()));
                    break;
                }
                case BOOLEAN: {
                    gen.writeBooleanField("value", ((Boolean)p.getValue()).booleanValue());
                    break;
                }
                case INTEGER: 
                case HASH160: 
                case INTEROP_INTERFACE: 
                case STRING: {
                    gen.writeStringField("value", p.getValue().toString());
                    break;
                }
                case ARRAY: {
                    gen.writeArrayFieldStart("value");
                    for (ContractParameter param : (ContractParameter[])p.getValue()) {
                        this.serializeParameter(param, gen);
                    }
                    gen.writeEndArray();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Parameter type '" + p.getParamType().toString() + "' not supported.");
                }
            }
        }
    }
}

