/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.constants.InteropServiceCode;
import io.neow3j.constants.OpCode;
import io.neow3j.contract.ContractParameter;
import io.neow3j.contract.ScriptHash;
import io.neow3j.model.types.CallFlags;
import io.neow3j.utils.BigIntegers;
import io.neow3j.utils.Numeric;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ScriptBuilder {
    private DataOutputStream stream;
    private ByteBuffer buffer;
    private ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
    private static final BigInteger minusOne = BigInteger.valueOf(-1L);
    private static final BigInteger sixteen = BigInteger.valueOf(16L);

    public ScriptBuilder() {
        this.stream = new DataOutputStream(this.byteStream);
        this.buffer = ByteBuffer.wrap(new byte[8]).order(ByteOrder.LITTLE_ENDIAN);
    }

    public ScriptBuilder opCode(OpCode opCode) {
        this.writeByte(opCode.getCode());
        return this;
    }

    public ScriptBuilder opCode(OpCode opCode, byte[] argument) {
        this.writeByte(opCode.getCode());
        this.write(argument);
        return this;
    }

    public ScriptBuilder contractCall(ScriptHash scriptHash, String method, List<ContractParameter> params) {
        if (params.size() > 0) {
            this.pushParams(params);
        } else {
            this.opCode(OpCode.NEWARRAY0);
        }
        this.pushInteger(CallFlags.ALL.getValue());
        this.pushData(method);
        this.pushData(scriptHash.toArray());
        this.sysCall(InteropServiceCode.SYSTEM_CONTRACT_CALL);
        return this;
    }

    public ScriptBuilder sysCall(InteropServiceCode operation) {
        this.writeByte(OpCode.SYSCALL.getCode());
        this.write(Numeric.hexStringToByteArray(operation.getHash()));
        return this;
    }

    public ScriptBuilder pushParams(List<ContractParameter> params) {
        for (int i = params.size() - 1; i >= 0; --i) {
            this.pushParam(params.get(i));
        }
        this.pushInteger(params.size());
        this.opCode(OpCode.PACK);
        return this;
    }

    public ScriptBuilder pushParam(ContractParameter param) {
        Object value = param.getValue();
        switch (param.getParamType()) {
            case BYTE_ARRAY: 
            case SIGNATURE: 
            case PUBLIC_KEY: {
                this.pushData((byte[])value);
                break;
            }
            case BOOLEAN: {
                this.pushBoolean((Boolean)value);
                break;
            }
            case INTEGER: {
                this.pushInteger((BigInteger)value);
                break;
            }
            case HASH160: 
            case HASH256: {
                this.pushData(((ScriptHash)value).toArray());
                break;
            }
            case STRING: {
                this.pushData((String)value);
                break;
            }
            case ARRAY: {
                this.pushArray((ContractParameter[])value);
                break;
            }
            case ANY: {
                if (value != null) break;
                this.opCode(OpCode.PUSHNULL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type '" + (Object)((Object)param.getParamType()) + "' not supported.");
            }
        }
        return this;
    }

    public ScriptBuilder pushInteger(long v) {
        return this.pushInteger(BigInteger.valueOf(v));
    }

    public ScriptBuilder pushInteger(BigInteger v) {
        int i = v.intValue();
        if (v.compareTo(minusOne) >= 0 && v.compareTo(sixteen) <= 0) {
            int opcode = OpCode.PUSH0.getCode() + i;
            return this.opCode(OpCode.get(opcode));
        }
        byte[] bytes = BigIntegers.toLittleEndianByteArray(v);
        if (bytes.length == 1) {
            return this.opCode(OpCode.PUSHINT8, bytes);
        }
        if (bytes.length == 2) {
            return this.opCode(OpCode.PUSHINT16, bytes);
        }
        if (bytes.length <= 4) {
            return this.opCode(OpCode.PUSHINT32, this.padRight(bytes, 4));
        }
        if (bytes.length <= 8) {
            return this.opCode(OpCode.PUSHINT64, this.padRight(bytes, 8));
        }
        if (bytes.length <= 16) {
            return this.opCode(OpCode.PUSHINT128, this.padRight(bytes, 16));
        }
        if (bytes.length <= 32) {
            return this.opCode(OpCode.PUSHINT256, this.padRight(bytes, 32));
        }
        throw new IllegalArgumentException("The given number (" + v.toString() + ") is out of range.");
    }

    private byte[] padRight(byte[] data, int desiredLenght) {
        if (data.length >= desiredLenght) {
            return data;
        }
        byte[] paddedData = new byte[desiredLenght];
        System.arraycopy(data, 0, paddedData, 0, data.length);
        return paddedData;
    }

    public ScriptBuilder pushBoolean(boolean bool) {
        if (bool) {
            this.writeByte(OpCode.PUSH1.getCode());
        } else {
            this.writeByte(OpCode.PUSH0.getCode());
        }
        return this;
    }

    public ScriptBuilder pushData(String data) {
        if (data != null) {
            this.pushData(data.getBytes(StandardCharsets.UTF_8));
        } else {
            this.pushData("".getBytes());
        }
        return this;
    }

    public ScriptBuilder pushData(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        if (data.length < 256) {
            this.opCode(OpCode.PUSHDATA1);
            this.writeByte((byte)data.length);
            this.write(data);
        } else if (data.length < 65536) {
            this.opCode(OpCode.PUSHDATA2);
            this.writeShort(data.length);
            this.write(data);
        } else {
            this.opCode(OpCode.PUSHDATA4);
            this.writeInt(data.length);
            this.write(data);
        }
        return this;
    }

    public ScriptBuilder pushArray(ContractParameter[] params) {
        for (int i = params.length - 1; i >= 0; --i) {
            this.pushParam(params[i]);
        }
        this.pushInteger(params.length);
        this.opCode(OpCode.PACK);
        return this;
    }

    public ScriptBuilder pack() {
        this.opCode(OpCode.PACK);
        return this;
    }

    private void writeByte(int v) {
        try {
            this.stream.writeByte(v);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    private void writeShort(int v) {
        this.buffer.putInt(0, v);
        try {
            this.stream.write(this.buffer.array(), 0, 2);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    private void writeInt(int v) {
        this.buffer.putInt(0, v);
        try {
            this.stream.write(this.buffer.array(), 0, 4);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    private void write(byte[] data) {
        try {
            this.stream.write(data);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    public byte[] toArray() {
        try {
            this.stream.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
        return this.byteStream.toByteArray();
    }

    public static byte[] buildVerificationScript(byte[] encodedPublicKey) {
        return new ScriptBuilder().pushData(encodedPublicKey).opCode(OpCode.PUSHNULL).sysCall(InteropServiceCode.NEO_CRYPTO_VERIFYWITHECDSASECP256R1).toArray();
    }

    public static byte[] buildVerificationScript(List<byte[]> encodedPublicKeys, int signingThreshold) {
        ScriptBuilder builder = new ScriptBuilder().pushInteger(signingThreshold);
        encodedPublicKeys.forEach(builder::pushData);
        return builder.pushInteger(encodedPublicKeys.size()).opCode(OpCode.PUSHNULL).sysCall(InteropServiceCode.NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256R1).toArray();
    }
}

