/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.constants.InteropServiceCode;
import io.neow3j.constants.OpCode;
import io.neow3j.constants.OperandSize;
import io.neow3j.io.BinaryReader;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.util.HashMap;

public class ScriptReader {
    public static InteropServiceCode getInteropServiceCode(String hash) {
        HashMap<String, InteropServiceCode> interopServiceCodeMap = new HashMap<String, InteropServiceCode>();
        for (InteropServiceCode code : InteropServiceCode.values()) {
            interopServiceCodeMap.put(code.getHash(), code);
        }
        if (interopServiceCodeMap.containsKey(hash)) {
            return (InteropServiceCode)((Object)interopServiceCodeMap.get(hash));
        }
        throw new IllegalArgumentException("Code is not a valid InteropServiceCode Hash.");
    }

    public static String convertToOpCodeString(String script) {
        return ScriptReader.convertToOpCodeString(Numeric.hexStringToByteArray(script));
    }

    public static String convertToOpCodeString(byte[] script) {
        BinaryReader r = new BinaryReader(script);
        StringBuilder builder = new StringBuilder();
        try {
            while (r.getPosition() < script.length) {
                OpCode code = OpCode.get(r.readByte());
                builder.append(code.name());
                OperandSize operandSize = OpCode.getOperandSize(code);
                if (operandSize == null) {
                    builder.append("\n");
                    continue;
                }
                if (operandSize.size() > 0) {
                    builder.append(" ");
                    builder.append(Numeric.toHexStringNoPrefix(r.readBytes(operandSize.size())));
                } else if (operandSize.prefixSize() > 0) {
                    int size = ScriptReader.getPrefixSize(r, operandSize);
                    builder.append(" ");
                    builder.append(size);
                    builder.append(" ");
                    builder.append(Numeric.toHexStringNoPrefix(r.readBytes(size)));
                }
                builder.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    private static int getPrefixSize(BinaryReader r, OperandSize operandSize) throws IOException {
        if (operandSize.prefixSize() == 1) {
            return r.readUnsignedByte();
        }
        if (operandSize.prefixSize() == 2) {
            return r.readInt16();
        }
        if (operandSize.prefixSize() == 4) {
            return r.readInt32();
        }
        throw new UnsupportedOperationException("Only operand prefix sizes 1, 2, and 4 are supported, but got " + operandSize.prefixSize());
    }
}

