/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.LinuxSecureRandom;
import java.security.SecureRandom;

public final class SecureRandomUtils {
    private static final SecureRandom SECURE_RANDOM;
    private static int isAndroid;

    public static SecureRandom secureRandom() {
        return SECURE_RANDOM;
    }

    static boolean isAndroidRuntime() {
        if (isAndroid == -1) {
            String runtime = System.getProperty("java.runtime.name");
            isAndroid = runtime != null && runtime.equals("Android Runtime") ? 1 : 0;
        }
        return isAndroid == 1;
    }

    public static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SecureRandomUtils.secureRandom().nextBytes(bytes);
        return bytes;
    }

    private SecureRandomUtils() {
    }

    static {
        if (SecureRandomUtils.isAndroidRuntime()) {
            new LinuxSecureRandom();
        }
        SECURE_RANDOM = new SecureRandom();
        isAndroid = -1;
    }
}

