/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.model.types;

import com.fasterxml.jackson.annotation.JsonValue;

public enum ContractParameterType {
    ANY("Any", 0),
    BOOLEAN("Boolean", 16),
    INTEGER("Integer", 17),
    BYTE_ARRAY("ByteArray", 18),
    STRING("String", 19),
    HASH160("Hash160", 20),
    HASH256("Hash256", 21),
    PUBLIC_KEY("PublicKey", 22),
    SIGNATURE("Signature", 23),
    ARRAY("Array", 32),
    MAP("Map", 34),
    INTEROP_INTERFACE("InteropInterface", 48),
    VOID("Void", 255);

    private String jsonValue;
    private byte byteValue;

    private ContractParameterType(String jsonValue, int v) {
        this.jsonValue = jsonValue;
        this.byteValue = (byte)v;
    }

    @JsonValue
    public String jsonValue() {
        return this.jsonValue;
    }

    public byte byteValue() {
        return this.byteValue;
    }

    public static ContractParameterType valueOf(byte byteValue) {
        for (ContractParameterType e : ContractParameterType.values()) {
            if (e.byteValue != byteValue) continue;
            return e;
        }
        throw new IllegalArgumentException();
    }

    public static ContractParameterType fromJsonValue(String jsonValue) {
        for (ContractParameterType e : ContractParameterType.values()) {
            if (!e.jsonValue.equals(jsonValue)) continue;
            return e;
        }
        throw new IllegalArgumentException();
    }
}

