/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.model.types;

import com.fasterxml.jackson.annotation.JsonValue;

public enum StackItemType {
    ANY("Any", 0),
    POINTER("Pointer", 16),
    BOOLEAN("Boolean", 32),
    INTEGER("Integer", 33),
    BYTE_STRING("ByteString", 40),
    BUFFER("Buffer", 48),
    ARRAY("Array", 64),
    STRUCT("Struct", 65),
    MAP("Map", 72),
    INTEROP_INTERFACE("InteropInterface", 96);

    public static final String ANY_VALUE = "Any";
    public static final String POINTER_VALUE = "Pointer";
    public static final String BOOLEAN_VALUE = "Boolean";
    public static final String INTEGER_VALUE = "Integer";
    public static final String BYTE_STRING_VALUE = "ByteString";
    public static final String BUFFER_VALUE = "Buffer";
    public static final String ARRAY_VALUE = "Array";
    public static final String STRUCT_VALUE = "Struct";
    public static final String MAP_VALUE = "Map";
    public static final String INTEROP_INTERFACE_VALUE = "InteropInterface";
    public static final byte INTEGER_CODE = 33;
    public static final byte BYTE_STRING_CODE = 40;
    public static final byte BUFFER_CODE = 48;
    private final String jsonValue;
    private final byte byteValue;

    private StackItemType(String jsonValue, int v) {
        this.jsonValue = jsonValue;
        this.byteValue = (byte)v;
    }

    public String getValue() {
        return this.jsonValue;
    }

    @JsonValue
    public String jsonValue() {
        return this.jsonValue;
    }

    public byte byteValue() {
        return this.byteValue;
    }

    public static StackItemType valueOf(byte byteValue) {
        for (StackItemType e : StackItemType.values()) {
            if (e.byteValue != byteValue) continue;
            return e;
        }
        throw new IllegalArgumentException("There exists no stack item with the provided byte value. The provided byte value was " + byteValue + ".");
    }

    public static StackItemType fromJsonValue(String jsonValue) {
        for (StackItemType e : StackItemType.values()) {
            if (!e.jsonValue.equals(jsonValue)) continue;
            return e;
        }
        throw new IllegalArgumentException("There exists no stack item with the provided json value. The provided json value was " + jsonValue + ".");
    }
}

