/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol;

import io.neow3j.protocol.Neow3jService;
import io.neow3j.protocol.core.JsonRpc2_0Neow3j;
import io.neow3j.protocol.core.Neo;
import io.neow3j.protocol.rx.Neow3jRx;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ScheduledExecutorService;

public abstract class Neow3j
implements Neo,
Neow3jRx {
    private Integer networkMagicNumber;
    private static Byte addressVersion = 53;

    public static Neow3j build(Neow3jService neow3jService) {
        return new JsonRpc2_0Neow3j(neow3jService);
    }

    public static Neow3j build(Neow3jService neow3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        return new JsonRpc2_0Neow3j(neow3jService, pollingInterval, scheduledExecutorService);
    }

    public abstract void shutdown();

    public byte[] getNetworkMagicNumber() throws IOException {
        if (this.networkMagicNumber == null) {
            this.networkMagicNumber = this.getVersion().send().getVersion().getMagic();
        }
        byte[] array = new byte[4];
        ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN).putInt(this.networkMagicNumber);
        return array;
    }

    public void setNetworkMagicNumber(int magicNumber) {
        this.networkMagicNumber = magicNumber;
    }

    public static byte getAddressVersion() {
        return addressVersion;
    }

    public static void setAddressVersion(byte version) {
        addressVersion = version;
    }
}

