/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.neow3j.protocol.Neow3jService;
import io.neow3j.protocol.ObjectMapperFactory;
import io.neow3j.protocol.core.Request;
import io.neow3j.protocol.core.Response;
import io.neow3j.protocol.notifications.Notification;
import io.neow3j.utils.Async;
import io.reactivex.Observable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public abstract class Service
implements Neow3jService {
    protected final ObjectMapper objectMapper;
    protected ExecutorService asyncExecutorService;

    public Service(ExecutorService executorService, boolean includeRawResponses) {
        this.objectMapper = ObjectMapperFactory.getObjectMapper(includeRawResponses);
        this.asyncExecutorService = executorService;
    }

    public Service(boolean includeRawResponses) {
        this.objectMapper = ObjectMapperFactory.getObjectMapper(includeRawResponses);
    }

    protected abstract InputStream performIO(String var1) throws IOException;

    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        String payload = this.objectMapper.writeValueAsString((Object)request);
        try (InputStream result = this.performIO(payload);){
            if (result != null) {
                Response response = (Response)this.objectMapper.readValue(result, responseType);
                return (T)response;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T extends Response> CompletableFuture<T> sendAsync(Request jsonRpc20Request, Class<T> responseType) {
        return Async.run(() -> this.send(jsonRpc20Request, responseType), this.asyncExecutorService);
    }

    @Override
    public <T extends Notification<?>> Observable<T> subscribe(Request request, String unsubscribeMethod, Class<T> responseType) {
        throw new UnsupportedOperationException(String.format("Service %s does not support subscriptions", this.getClass().getSimpleName()));
    }
}

