/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core;

import io.neow3j.contract.ContractParameter;
import io.neow3j.contract.ScriptHash;
import io.neow3j.crypto.Base64;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.Neow3jService;
import io.neow3j.protocol.core.BlockParameter;
import io.neow3j.protocol.core.BlockParameterIndex;
import io.neow3j.protocol.core.Request;
import io.neow3j.protocol.core.methods.response.NeoBlockCount;
import io.neow3j.protocol.core.methods.response.NeoBlockHash;
import io.neow3j.protocol.core.methods.response.NeoBlockHeaderCount;
import io.neow3j.protocol.core.methods.response.NeoCalculateNetworkFee;
import io.neow3j.protocol.core.methods.response.NeoCloseWallet;
import io.neow3j.protocol.core.methods.response.NeoConnectionCount;
import io.neow3j.protocol.core.methods.response.NeoDumpPrivKey;
import io.neow3j.protocol.core.methods.response.NeoGetApplicationLog;
import io.neow3j.protocol.core.methods.response.NeoGetBlock;
import io.neow3j.protocol.core.methods.response.NeoGetCommittee;
import io.neow3j.protocol.core.methods.response.NeoGetContractState;
import io.neow3j.protocol.core.methods.response.NeoGetMemPool;
import io.neow3j.protocol.core.methods.response.NeoGetNativeContracts;
import io.neow3j.protocol.core.methods.response.NeoGetNep17Balances;
import io.neow3j.protocol.core.methods.response.NeoGetNep17Transfers;
import io.neow3j.protocol.core.methods.response.NeoGetNewAddress;
import io.neow3j.protocol.core.methods.response.NeoGetNextBlockValidators;
import io.neow3j.protocol.core.methods.response.NeoGetPeers;
import io.neow3j.protocol.core.methods.response.NeoGetRawBlock;
import io.neow3j.protocol.core.methods.response.NeoGetRawMemPool;
import io.neow3j.protocol.core.methods.response.NeoGetRawTransaction;
import io.neow3j.protocol.core.methods.response.NeoGetStorage;
import io.neow3j.protocol.core.methods.response.NeoGetTransaction;
import io.neow3j.protocol.core.methods.response.NeoGetTransactionHeight;
import io.neow3j.protocol.core.methods.response.NeoGetUnclaimedGas;
import io.neow3j.protocol.core.methods.response.NeoGetVersion;
import io.neow3j.protocol.core.methods.response.NeoGetWalletBalance;
import io.neow3j.protocol.core.methods.response.NeoGetWalletUnclaimedGas;
import io.neow3j.protocol.core.methods.response.NeoImportPrivKey;
import io.neow3j.protocol.core.methods.response.NeoInvokeContractVerify;
import io.neow3j.protocol.core.methods.response.NeoInvokeFunction;
import io.neow3j.protocol.core.methods.response.NeoInvokeScript;
import io.neow3j.protocol.core.methods.response.NeoListAddress;
import io.neow3j.protocol.core.methods.response.NeoListPlugins;
import io.neow3j.protocol.core.methods.response.NeoOpenWallet;
import io.neow3j.protocol.core.methods.response.NeoSendFrom;
import io.neow3j.protocol.core.methods.response.NeoSendMany;
import io.neow3j.protocol.core.methods.response.NeoSendRawTransaction;
import io.neow3j.protocol.core.methods.response.NeoSendToAddress;
import io.neow3j.protocol.core.methods.response.NeoSubmitBlock;
import io.neow3j.protocol.core.methods.response.NeoValidateAddress;
import io.neow3j.protocol.core.methods.response.TransactionSendAsset;
import io.neow3j.protocol.core.methods.response.TransactionSigner;
import io.neow3j.protocol.rx.JsonRpc2_0Rx;
import io.neow3j.transaction.Signer;
import io.neow3j.utils.Async;
import io.neow3j.utils.Numeric;
import io.neow3j.utils.Strings;
import io.reactivex.Observable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonRpc2_0Neow3j
extends Neow3j {
    public static final int DEFAULT_BLOCK_TIME = 15000;
    protected final Neow3jService neow3jService;
    private final JsonRpc2_0Rx neow3jRx;
    private final long blockTime;
    private final ScheduledExecutorService scheduledExecutorService;

    public JsonRpc2_0Neow3j(Neow3jService neow3jService) {
        this(neow3jService, 15000L, Async.defaultExecutorService());
    }

    public JsonRpc2_0Neow3j(Neow3jService neow3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        this.neow3jService = neow3jService;
        this.neow3jRx = new JsonRpc2_0Rx(this, scheduledExecutorService);
        this.blockTime = pollingInterval;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public Request<?, NeoBlockHash> getBestBlockHash() {
        return new Request("getbestblockhash", Collections.emptyList(), this.neow3jService, NeoBlockHash.class);
    }

    @Override
    public Request<?, NeoBlockHash> getBlockHash(BlockParameterIndex blockIndex) {
        return new Request<BigInteger, NeoBlockHash>("getblockhash", Collections.singletonList(blockIndex.getBlockIndex()), this.neow3jService, NeoBlockHash.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlock(String address, boolean returnFullTransactionObjects) {
        if (returnFullTransactionObjects) {
            return new Request<Serializable, NeoGetBlock>("getblock", Arrays.asList(address, 1), this.neow3jService, NeoGetBlock.class);
        }
        return this.getBlockHeader(address);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlock(String address) {
        return new Request<Serializable, NeoGetRawBlock>("getblock", Arrays.asList(address, 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlock(BlockParameterIndex blockIndex, boolean returnFullTransactionObjects) {
        if (returnFullTransactionObjects) {
            return new Request<Number, NeoGetBlock>("getblock", Arrays.asList(blockIndex.getBlockIndex(), 1), this.neow3jService, NeoGetBlock.class);
        }
        return this.getBlockHeader(blockIndex);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlock(BlockParameterIndex blockIndex) {
        return new Request<Number, NeoGetRawBlock>("getblock", Arrays.asList(blockIndex.getBlockIndex(), 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoBlockHeaderCount> getBlockHeaderCount() {
        return new Request("getblockheadercount", Collections.emptyList(), this.neow3jService, NeoBlockHeaderCount.class);
    }

    @Override
    public Request<?, NeoBlockCount> getBlockCount() {
        return new Request("getblockcount", Collections.emptyList(), this.neow3jService, NeoBlockCount.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlockHeader(String hash) {
        return new Request<Serializable, NeoGetBlock>("getblockheader", Arrays.asList(hash, 1), this.neow3jService, NeoGetBlock.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlockHeader(BlockParameterIndex blockIndex) {
        return new Request<Number, NeoGetBlock>("getblockheader", Arrays.asList(blockIndex.getBlockIndex(), 1), this.neow3jService, NeoGetBlock.class);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlockHeader(String hash) {
        return new Request<Serializable, NeoGetRawBlock>("getblockheader", Arrays.asList(hash, 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlockHeader(BlockParameterIndex blockIndex) {
        return new Request<Number, NeoGetRawBlock>("getblockheader", Arrays.asList(blockIndex.getBlockIndex(), 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoGetNativeContracts> getNativeContracts() {
        return new Request("getnativecontracts", Collections.emptyList(), this.neow3jService, NeoGetNativeContracts.class);
    }

    @Override
    public Request<?, NeoGetContractState> getContractState(ScriptHash scriptHash) {
        return new Request<String, NeoGetContractState>("getcontractstate", Collections.singletonList(scriptHash.toString()), this.neow3jService, NeoGetContractState.class);
    }

    @Override
    public Request<?, NeoGetContractState> getContractState(String contractName) {
        return new Request<String, NeoGetContractState>("getcontractstate", Collections.singletonList(contractName), this.neow3jService, NeoGetContractState.class);
    }

    @Override
    public Request<?, NeoGetMemPool> getMemPool() {
        return new Request<Integer, NeoGetMemPool>("getrawmempool", Collections.singletonList(1), this.neow3jService, NeoGetMemPool.class);
    }

    @Override
    public Request<?, NeoGetRawMemPool> getRawMemPool() {
        return new Request("getrawmempool", Collections.emptyList(), this.neow3jService, NeoGetRawMemPool.class);
    }

    @Override
    public Request<?, NeoGetTransaction> getTransaction(String txId) {
        return new Request<Serializable, NeoGetTransaction>("getrawtransaction", Arrays.asList(txId, 1), this.neow3jService, NeoGetTransaction.class);
    }

    @Override
    public Request<?, NeoGetRawTransaction> getRawTransaction(String txId) {
        return new Request<Serializable, NeoGetRawTransaction>("getrawtransaction", Arrays.asList(txId, 0), this.neow3jService, NeoGetRawTransaction.class);
    }

    @Override
    public Request<?, NeoGetStorage> getStorage(String contractAddress, String keyHexString) {
        return new Request<String, NeoGetStorage>("getstorage", Arrays.asList(contractAddress, Base64.encode(keyHexString)), this.neow3jService, NeoGetStorage.class);
    }

    @Override
    public Request<?, NeoGetTransactionHeight> getTransactionHeight(String txId) {
        return new Request<String, NeoGetTransactionHeight>("gettransactionheight", Collections.singletonList(txId), this.neow3jService, NeoGetTransactionHeight.class);
    }

    @Override
    public Request<?, NeoGetNextBlockValidators> getNextBlockValidators() {
        return new Request("getnextblockvalidators", Collections.emptyList(), this.neow3jService, NeoGetNextBlockValidators.class);
    }

    @Override
    public Request<?, NeoGetCommittee> getCommittee() {
        return new Request("getcommittee", Collections.emptyList(), this.neow3jService, NeoGetCommittee.class);
    }

    @Override
    public Request<?, NeoConnectionCount> getConnectionCount() {
        return new Request("getconnectioncount", Collections.emptyList(), this.neow3jService, NeoConnectionCount.class);
    }

    @Override
    public Request<?, NeoGetPeers> getPeers() {
        return new Request("getpeers", Collections.emptyList(), this.neow3jService, NeoGetPeers.class);
    }

    @Override
    public Request<?, NeoGetVersion> getVersion() {
        return new Request("getversion", Collections.emptyList(), this.neow3jService, NeoGetVersion.class);
    }

    @Override
    public Request<?, NeoSendRawTransaction> sendRawTransaction(String rawTransactionHex) {
        return new Request<String, NeoSendRawTransaction>("sendrawtransaction", Collections.singletonList(Base64.encode(Numeric.hexStringToByteArray(rawTransactionHex))), this.neow3jService, NeoSendRawTransaction.class);
    }

    @Override
    public Request<?, NeoSubmitBlock> submitBlock(String serializedBlockAsHex) {
        return new Request<String, NeoSubmitBlock>("submitblock", Collections.singletonList(serializedBlockAsHex), this.neow3jService, NeoSubmitBlock.class);
    }

    @Override
    public Request<?, NeoInvokeFunction> invokeFunction(String contractScriptHash, String functionName, Signer ... signers) {
        return this.invokeFunction(contractScriptHash, functionName, (List<ContractParameter>)null, signers);
    }

    @Override
    public Request<?, NeoInvokeFunction> invokeFunction(String contractScriptHash, String functionName, List<ContractParameter> contractParams, Signer ... signers) {
        List txSigners;
        if (contractParams == null) {
            contractParams = new ArrayList<ContractParameter>();
        }
        List<Object> params = (txSigners = Arrays.stream(signers).map(TransactionSigner::new).collect(Collectors.toList())).size() > 0 ? Arrays.asList(contractScriptHash, functionName, contractParams, txSigners) : Arrays.asList(contractScriptHash, functionName, contractParams);
        return new Request("invokefunction", params.stream().filter(Objects::nonNull).collect(Collectors.toList()), this.neow3jService, NeoInvokeFunction.class);
    }

    @Override
    public Request<?, NeoInvokeScript> invokeScript(String script, Signer ... signers) {
        List<Object> params = signers.length > 0 ? Arrays.asList(script, Arrays.stream(signers).map(TransactionSigner::new).collect(Collectors.toList())) : Collections.singletonList(script);
        return new Request<String, NeoInvokeScript>("invokescript", params, this.neow3jService, NeoInvokeScript.class);
    }

    @Override
    public Request<?, NeoInvokeContractVerify> invokeContractVerify(String scriptHash, List<ContractParameter> methodParams, Signer ... signers) {
        if (methodParams == null) {
            methodParams = new ArrayList<ContractParameter>();
        }
        List txSigners = Arrays.stream(signers).map(TransactionSigner::new).collect(Collectors.toList());
        List<Object> params = Arrays.asList(scriptHash, methodParams, txSigners);
        return new Request("invokecontractverify", params.stream().filter(Objects::nonNull).collect(Collectors.toList()), this.neow3jService, NeoInvokeContractVerify.class);
    }

    @Override
    public Request<?, NeoGetUnclaimedGas> getUnclaimedGas(String address) {
        return new Request<String, NeoGetUnclaimedGas>("getunclaimedgas", Collections.singletonList(address), this.neow3jService, NeoGetUnclaimedGas.class);
    }

    @Override
    public Request<?, NeoListPlugins> listPlugins() {
        return new Request("listplugins", Collections.emptyList(), this.neow3jService, NeoListPlugins.class);
    }

    @Override
    public Request<?, NeoValidateAddress> validateAddress(String address) {
        return new Request<String, NeoValidateAddress>("validateaddress", Collections.singletonList(address), this.neow3jService, NeoValidateAddress.class);
    }

    @Override
    public Request<?, NeoCloseWallet> closeWallet() {
        return new Request("closewallet", Collections.emptyList(), this.neow3jService, NeoCloseWallet.class);
    }

    @Override
    public Request<?, NeoDumpPrivKey> dumpPrivKey(String address) {
        return new Request<String, NeoDumpPrivKey>("dumpprivkey", Collections.singletonList(address), this.neow3jService, NeoDumpPrivKey.class);
    }

    @Override
    public Request<?, NeoGetWalletBalance> getWalletBalance(String assetId) {
        return new Request<String, NeoGetWalletBalance>("getwalletbalance", Collections.singletonList(Numeric.cleanHexPrefix(assetId)), this.neow3jService, NeoGetWalletBalance.class);
    }

    @Override
    public Request<?, NeoGetNewAddress> getNewAddress() {
        return new Request("getnewaddress", Collections.emptyList(), this.neow3jService, NeoGetNewAddress.class);
    }

    @Override
    public Request<?, NeoGetWalletUnclaimedGas> getWalletUnclaimedGas() {
        return new Request("getwalletunclaimedgas", Collections.emptyList(), this.neow3jService, NeoGetWalletUnclaimedGas.class);
    }

    @Override
    public Request<?, NeoImportPrivKey> importPrivKey(String privateKeyInWIF) {
        return new Request<String, NeoImportPrivKey>("importprivkey", Collections.singletonList(privateKeyInWIF), this.neow3jService, NeoImportPrivKey.class);
    }

    @Override
    public Request<?, NeoCalculateNetworkFee> calculateNetworkFee(String txHex) {
        return new Request<String, NeoCalculateNetworkFee>("calculatenetworkfee", Collections.singletonList(Base64.encode(Numeric.hexStringToByteArray(txHex))), this.neow3jService, NeoCalculateNetworkFee.class);
    }

    @Override
    public Request<?, NeoListAddress> listAddress() {
        return new Request("listaddress", Collections.emptyList(), this.neow3jService, NeoListAddress.class);
    }

    @Override
    public Request<?, NeoOpenWallet> openWallet(String walletPath, String password) {
        return new Request<String, NeoOpenWallet>("openwallet", Arrays.asList(walletPath, password), this.neow3jService, NeoOpenWallet.class);
    }

    @Override
    public Request<?, NeoSendFrom> sendFrom(String fromAddress, String assetId, String toAddress, String value) {
        return new Request<String, NeoSendFrom>("sendfrom", Arrays.asList(assetId, fromAddress, toAddress, value), this.neow3jService, NeoSendFrom.class);
    }

    @Override
    public Request<?, NeoSendFrom> sendFrom(String fromAddress, TransactionSendAsset txSendAsset) {
        return this.sendFrom(fromAddress, txSendAsset.getAsset(), txSendAsset.getAddress(), txSendAsset.getValue());
    }

    @Override
    public Request<?, NeoSendMany> sendMany(List<TransactionSendAsset> txSendAsset) {
        return new Request<List, NeoSendMany>("sendmany", Arrays.asList(txSendAsset.stream().filter(Objects::nonNull).collect(Collectors.toList())), this.neow3jService, NeoSendMany.class);
    }

    @Override
    public Request<?, NeoSendMany> sendMany(String fromAddress, List<TransactionSendAsset> txSendAsset) {
        return new Request<Object, NeoSendMany>("sendmany", Arrays.asList(fromAddress, txSendAsset.stream().filter(Objects::nonNull).collect(Collectors.toList())), this.neow3jService, NeoSendMany.class);
    }

    @Override
    public Request<?, NeoSendToAddress> sendToAddress(String assetId, String toAddress, String value) {
        return new Request("sendtoaddress", Stream.of(assetId, toAddress, value).filter(param -> param != null && !Strings.isEmpty(param)).collect(Collectors.toList()), this.neow3jService, NeoSendToAddress.class);
    }

    @Override
    public Request<?, NeoSendToAddress> sendToAddress(TransactionSendAsset txSendAsset) {
        return this.sendToAddress(txSendAsset.getAsset(), txSendAsset.getAddress(), txSendAsset.getValue());
    }

    @Override
    public Request<?, NeoGetApplicationLog> getApplicationLog(String txId) {
        return new Request<String, NeoGetApplicationLog>("getapplicationlog", Collections.singletonList(txId), this.neow3jService, NeoGetApplicationLog.class);
    }

    @Override
    public Request<?, NeoGetNep17Balances> getNep17Balances(String address) {
        return new Request<String, NeoGetNep17Balances>("getnep17balances", Collections.singletonList(address), this.neow3jService, NeoGetNep17Balances.class);
    }

    @Override
    public Request<?, NeoGetNep17Transfers> getNep17Transfers(String address) {
        return new Request<String, NeoGetNep17Transfers>("getnep17transfers", Collections.singletonList(address), this.neow3jService, NeoGetNep17Transfers.class);
    }

    @Override
    public Request<?, NeoGetNep17Transfers> getNep17Transfers(String address, Date from) {
        return new Request<Serializable, NeoGetNep17Transfers>("getnep17transfers", Arrays.asList(address, from.getTime()), this.neow3jService, NeoGetNep17Transfers.class);
    }

    @Override
    public Request<?, NeoGetNep17Transfers> getNep17Transfers(String address, Date from, Date until) {
        return new Request<Serializable, NeoGetNep17Transfers>("getnep17transfers", Arrays.asList(address, from.getTime(), until.getTime()), this.neow3jService, NeoGetNep17Transfers.class);
    }

    @Override
    public Observable<NeoGetBlock> blockObservable(boolean fullTransactionObjects) {
        return this.neow3jRx.blockObservable(fullTransactionObjects, this.blockTime);
    }

    @Override
    public Observable<NeoGetBlock> replayBlocksObservable(BlockParameter startBlock, BlockParameter endBlock, boolean fullTransactionObjects) {
        return this.neow3jRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects);
    }

    @Override
    public Observable<NeoGetBlock> replayBlocksObservable(BlockParameter startBlock, BlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.neow3jRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, ascending);
    }

    @Override
    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BlockParameter startBlock, boolean fullTransactionObjects, Observable<NeoGetBlock> onCompleteObservable) {
        return this.neow3jRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, onCompleteObservable);
    }

    @Override
    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BlockParameter startBlock, boolean fullTransactionObjects) {
        return this.neow3jRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects);
    }

    @Override
    public Observable<NeoGetBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(BlockParameter startBlock, boolean fullTransactionObjects) {
        return this.neow3jRx.catchUpToLatestAndSubscribeToNewBlocksObservable(startBlock, fullTransactionObjects, this.blockTime);
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        try {
            this.neow3jService.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close neow3j service", e);
        }
    }
}

