/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Role {
    STATE_VALIDATOR("StateValidator", 4),
    ORACLE("Oracle", 8);

    private String jsonValue;
    private byte byteValue;

    private Role(String jsonValue, int byteValue) {
        this.jsonValue = jsonValue;
        this.byteValue = (byte)byteValue;
    }

    @JsonCreator
    public static Role fromJson(Object value) {
        if (value instanceof String) {
            return Role.fromJsonValue((String)value);
        }
        if (value instanceof Integer) {
            return Role.valueOf(((Integer)value).byteValue());
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", Role.class.getName()));
    }

    public static Role valueOf(byte byteValue) {
        for (Role e : Role.values()) {
            if (e.byteValue != byteValue) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", Role.class.getName()));
    }

    public static Role fromJsonValue(String jsonValue) {
        for (Role e : Role.values()) {
            if (!e.jsonValue.equals(jsonValue)) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", Role.class.getName()));
    }

    public byte byteValue() {
        return this.byteValue;
    }

    @JsonValue
    public String jsonValue() {
        return this.jsonValue;
    }
}

