/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.contract.ScriptHash;
import io.neow3j.model.types.StackItemType;
import io.neow3j.protocol.core.methods.response.StackItem;
import io.neow3j.utils.BigIntegers;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BufferStackItem
extends StackItem {
    @JsonProperty(value="value")
    private byte[] value;

    public BufferStackItem() {
        super(StackItemType.BUFFER);
    }

    public BufferStackItem(byte[] value) {
        super(StackItemType.BUFFER);
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getAsAddress() {
        return new ScriptHash(this.getValue()).toAddress();
    }

    public String getAsString() {
        return new String(this.getValue(), StandardCharsets.UTF_8);
    }

    public BigInteger getAsNumber() {
        if (this.getValue().length == 0) {
            return BigInteger.ZERO;
        }
        return BigIntegers.fromLittleEndianByteArray(this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BufferStackItem)) {
            return false;
        }
        BufferStackItem other = (BufferStackItem)o;
        return this.getType() == other.getType() && Arrays.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, Arrays.hashCode(this.getValue())});
    }
}

