/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.contract.ScriptHash;
import io.neow3j.model.types.StackItemType;
import io.neow3j.protocol.core.methods.response.StackItem;
import io.neow3j.utils.BigIntegers;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ByteStringStackItem
extends StackItem {
    @JsonProperty(value="value")
    private byte[] value;

    public ByteStringStackItem() {
        super(StackItemType.BYTE_STRING);
    }

    public ByteStringStackItem(byte[] value) {
        super(StackItemType.BYTE_STRING);
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getAsAddress() {
        return new ScriptHash(this.getValue()).toAddress();
    }

    public String getAsString() {
        return new String(this.getValue(), StandardCharsets.UTF_8);
    }

    public String getAsHexString() {
        return Numeric.toHexStringNoPrefix(this.getValue());
    }

    public BigInteger getAsNumber() {
        if (this.getValue().length == 0) {
            return BigInteger.ZERO;
        }
        return BigIntegers.fromLittleEndianByteArray(this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteStringStackItem)) {
            return false;
        }
        ByteStringStackItem other = (ByteStringStackItem)o;
        return this.getType() == other.getType() && Arrays.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, Arrays.hashCode(this.getValue())});
    }
}

