/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import io.neow3j.model.types.StackItemType;
import io.neow3j.protocol.core.methods.response.StackItem;
import java.math.BigInteger;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IntegerStackItem
extends StackItem {
    @JsonProperty(value="value")
    private BigInteger value;

    public IntegerStackItem() {
        super(StackItemType.INTEGER);
    }

    public IntegerStackItem(BigInteger value) {
        super(StackItemType.INTEGER);
        this.value = value;
    }

    @JsonSetter(value="value")
    public void setValue(BigInteger value) {
        this.value = value != null ? value : BigInteger.ZERO;
    }

    @JsonValue
    public BigInteger getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerStackItem)) {
            return false;
        }
        IntegerStackItem other = (IntegerStackItem)o;
        return this.getType() == other.getType() && this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getValue()});
    }
}

