/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.neow3j.model.types.StackItemType;
import io.neow3j.protocol.core.methods.response.ByteStringStackItem;
import io.neow3j.protocol.core.methods.response.StackItem;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=StackMapDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MapStackItem
extends StackItem {
    @JsonProperty(value="value")
    private Map<StackItem, StackItem> value;

    public MapStackItem() {
        super(StackItemType.MAP);
    }

    public MapStackItem(Map<StackItem, StackItem> value) {
        super(StackItemType.MAP);
        this.value = value;
    }

    public Map<StackItem, StackItem> getValue() {
        return this.value;
    }

    public StackItem get(String key) {
        for (Map.Entry<StackItem, StackItem> e : this.getValue().entrySet()) {
            if (!(e.getKey() instanceof ByteStringStackItem) || !e.getKey().asByteString().getAsString().equals(key)) continue;
            return e.getValue();
        }
        return null;
    }

    public StackItem get(byte[] key) {
        for (Map.Entry<StackItem, StackItem> e : this.getValue().entrySet()) {
            if (!(e.getKey() instanceof ByteStringStackItem) || !Arrays.equals(e.getKey().asByteString().getValue(), key)) continue;
            return e.getValue();
        }
        return null;
    }

    public StackItem get(StackItem key) {
        return this.getValue().get(key);
    }

    public int size() {
        return this.getValue().size();
    }

    public boolean isEmpty() {
        return this.getValue().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapStackItem)) {
            return false;
        }
        MapStackItem other = (MapStackItem)o;
        return this.getType() == other.getType() && Objects.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public static class StackMapDeserializer
    extends StdDeserializer<StackItem> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        protected StackMapDeserializer() {
            this(null);
        }

        protected StackMapDeserializer(Class<MapStackItem> vc) {
            super(vc);
        }

        public MapStackItem deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return this.deserializeMapStackItem(node);
        }

        private MapStackItem deserializeMapStackItem(JsonNode itemNode) throws IOException {
            JsonNode valueNode = itemNode.get("value");
            Iterator elements = valueNode.elements();
            HashMap<StackItem, StackItem> map = new HashMap<StackItem, StackItem>();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                JsonNode keyStackItem = element.get("key");
                StackItem keyItem = (StackItem)this.objectMapper.readValue(keyStackItem.toString(), StackItem.class);
                JsonNode valueStackItem = element.get("value");
                StackItem valueItem = (StackItem)this.objectMapper.readValue(valueStackItem.toString(), StackItem.class);
                map.put(keyItem, valueItem);
            }
            return new MapStackItem(map);
        }
    }
}

