/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.methods.response.StackItem;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NeoApplicationLog {
    @JsonProperty(value="txid")
    private String transactionId;
    @JsonProperty(value="executions")
    private List<Execution> executions;

    public NeoApplicationLog() {
    }

    public NeoApplicationLog(String transactionId, List<Execution> executions) {
        this.transactionId = transactionId;
        this.executions = executions;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public List<Execution> getExecutions() {
        return this.executions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoApplicationLog)) {
            return false;
        }
        NeoApplicationLog that = (NeoApplicationLog)o;
        return Objects.equals(this.getTransactionId(), that.getTransactionId());
    }

    public int hashCode() {
        return Objects.hash(this.getTransactionId(), this.getExecutions());
    }

    public String toString() {
        return "NeoApplicationLog{transactionId='" + this.transactionId + '\'' + ", executions=" + this.executions + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Execution {
        @JsonProperty(value="trigger")
        private String trigger;
        @JsonProperty(value="vmstate")
        private String state;
        @JsonProperty(value="exception")
        private String exception;
        @JsonProperty(value="gasconsumed")
        private String gasConsumed;
        @JsonProperty(value="stack")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<StackItem> stack;
        @JsonProperty(value="notifications")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Notification> notifications;

        public Execution() {
        }

        public Execution(String trigger, String state, String exception, String gasConsumed, List<StackItem> stack, List<Notification> notifications) {
            this.trigger = trigger;
            this.state = state;
            this.exception = exception;
            this.gasConsumed = gasConsumed;
            this.stack = stack;
            this.notifications = notifications;
        }

        public String getTrigger() {
            return this.trigger;
        }

        public String getState() {
            return this.state;
        }

        public String getException() {
            return this.exception;
        }

        public String getGasConsumed() {
            return this.gasConsumed;
        }

        public List<StackItem> getStack() {
            return this.stack;
        }

        public List<Notification> getNotifications() {
            return this.notifications;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Execution)) {
                return false;
            }
            Execution that = (Execution)o;
            return Objects.equals(this.getTrigger(), that.getTrigger()) && Objects.equals(this.getState(), that.getState()) && Objects.equals(this.getException(), that.getException()) && Objects.equals(this.getGasConsumed(), that.getGasConsumed()) && Objects.equals(this.getStack(), that.getStack()) && Objects.equals(this.getNotifications(), that.getNotifications());
        }

        public int hashCode() {
            return Objects.hash(this.getTrigger(), this.getState(), this.getException(), this.getGasConsumed(), this.getStack(), this.getNotifications());
        }

        public String toString() {
            return "Execution{trigger='" + this.trigger + '\'' + ", state='" + this.state + '\'' + ", exception='" + this.exception + '\'' + ", gasConsumed='" + this.gasConsumed + '\'' + ", stack=" + this.stack + ", notifications=" + this.notifications + '}';
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Notification {
            @JsonProperty(value="contract")
            private String contract;
            @JsonProperty(value="eventname")
            private String eventName;
            @JsonProperty(value="state")
            private StackItem state;

            public Notification() {
            }

            public Notification(String contract, String eventName, StackItem state) {
                this.contract = contract;
                this.eventName = eventName;
                this.state = state;
            }

            public String getContract() {
                return this.contract;
            }

            public String getEventName() {
                return this.eventName;
            }

            public StackItem getState() {
                return this.state;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Notification)) {
                    return false;
                }
                Notification that = (Notification)o;
                return Objects.equals(this.getContract(), that.getContract()) && Objects.equals(this.getEventName(), that.getEventName()) && Objects.equals(this.getState(), that.getState());
            }

            public int hashCode() {
                return Objects.hash(this.getContract(), this.getEventName(), this.getState());
            }

            public String toString() {
                return "Notification{contract='" + this.contract + '\'' + ", eventname=" + this.eventName + ", state=" + this.state + '}';
            }
        }
    }
}

