/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.methods.response.ConsensusData;
import io.neow3j.protocol.core.methods.response.NeoWitness;
import io.neow3j.protocol.core.methods.response.Transaction;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NeoBlock {
    @JsonProperty(value="hash")
    private String hash;
    @JsonProperty(value="size")
    private long size;
    @JsonProperty(value="version")
    private int version;
    @JsonProperty(value="previousblockhash")
    private String prevBlockHash;
    @JsonProperty(value="merkleroot")
    private String merkleRootHash;
    @JsonProperty(value="time")
    private long time;
    @JsonProperty(value="index")
    private long index;
    @JsonProperty(value="nextconsensus")
    private String nextConsensus;
    @JsonProperty(value="witnesses")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<NeoWitness> witnesses;
    @JsonProperty(value="consensusdata")
    private ConsensusData consensusData;
    @JsonProperty(value="tx")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Transaction> transactions;
    @JsonProperty(value="confirmations")
    private int confirmations;
    @JsonProperty(value="nextblockhash")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String nextBlockHash;

    public NeoBlock() {
    }

    public NeoBlock(String hash, long size, int version, String prevBlockHash, String merkleRootHash, long time, long index, String nextConsensus, List<NeoWitness> witnesses, ConsensusData consensusData, List<Transaction> transactions, int confirmations, String nextBlockHash) {
        this.hash = hash;
        this.size = size;
        this.version = version;
        this.prevBlockHash = prevBlockHash;
        this.merkleRootHash = merkleRootHash;
        this.time = time;
        this.index = index;
        this.nextConsensus = nextConsensus;
        this.witnesses = witnesses;
        this.consensusData = consensusData;
        this.transactions = transactions;
        this.confirmations = confirmations;
        this.nextBlockHash = nextBlockHash;
    }

    public String getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }

    public int getVersion() {
        return this.version;
    }

    public String getPrevBlockHash() {
        return this.prevBlockHash;
    }

    public String getMerkleRootHash() {
        return this.merkleRootHash;
    }

    public long getTime() {
        return this.time;
    }

    public long getIndex() {
        return this.index;
    }

    public String getNextConsensus() {
        return this.nextConsensus;
    }

    public List<NeoWitness> getWitnesses() {
        return this.witnesses;
    }

    public ConsensusData getConsensusData() {
        return this.consensusData;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public int getConfirmations() {
        return this.confirmations;
    }

    public String getNextBlockHash() {
        return this.nextBlockHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoBlock)) {
            return false;
        }
        NeoBlock neoBlock = (NeoBlock)o;
        return this.getSize() == neoBlock.getSize() && this.getVersion() == neoBlock.getVersion() && this.getTime() == neoBlock.getTime() && this.getIndex() == neoBlock.getIndex() && this.getConfirmations() == neoBlock.getConfirmations() && Objects.equals(this.getHash(), neoBlock.getHash()) && Objects.equals(this.getPrevBlockHash(), neoBlock.getPrevBlockHash()) && Objects.equals(this.getMerkleRootHash(), neoBlock.getMerkleRootHash()) && Objects.equals(this.getNextConsensus(), neoBlock.getNextConsensus()) && Objects.equals(this.getWitnesses(), neoBlock.getWitnesses()) && Objects.equals(this.getConsensusData(), neoBlock.getConsensusData()) && Objects.equals(this.getTransactions(), neoBlock.getTransactions()) && Objects.equals(this.getNextBlockHash(), neoBlock.getNextBlockHash());
    }

    public int hashCode() {
        return Objects.hash(this.getHash(), this.getSize(), this.getVersion(), this.getPrevBlockHash(), this.getMerkleRootHash(), this.getTime(), this.getIndex(), this.getNextConsensus(), this.getWitnesses(), this.getConsensusData(), this.getTransactions(), this.getConfirmations(), this.getNextBlockHash());
    }

    public String toString() {
        return "NeoBlock{hash='" + this.hash + '\'' + ", size=" + this.size + ", version=" + this.version + ", prevBlockHash='" + this.prevBlockHash + '\'' + ", merkleRootHash='" + this.merkleRootHash + '\'' + ", time=" + this.time + ", index=" + this.index + ", nextConsensus='" + this.nextConsensus + '\'' + ", witnesses=" + this.witnesses + ", consensusData=" + this.consensusData + ", transactions=" + this.transactions + ", confirmations=" + this.confirmations + ", nextBlockHash='" + this.nextBlockHash + '\'' + '}';
    }
}

