/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.Response;
import java.util.List;
import java.util.Objects;

public class NeoGetAccountState
extends Response<State> {
    public State getAccountState() {
        return (State)this.getResult();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Balance {
        @JsonProperty(value="asset")
        private String assetAddress;
        @JsonProperty(value="value")
        private String value;

        public Balance() {
        }

        public Balance(String assetAddress, String value) {
            this.assetAddress = assetAddress;
            this.value = value;
        }

        public String getAssetAddress() {
            return this.assetAddress;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance balance = (Balance)o;
            return Objects.equals(this.getAssetAddress(), balance.getAssetAddress()) && Objects.equals(this.getValue(), balance.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getAssetAddress(), this.getValue());
        }

        public String toString() {
            return "Balance{assetAddress='" + this.assetAddress + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class State {
        @JsonProperty(value="version")
        private int version;
        @JsonProperty(value="script_hash")
        private String scriptHash;
        @JsonProperty(value="frozen")
        private Boolean frozen;
        @JsonProperty(value="votes")
        private List<String> votes;
        @JsonProperty(value="balances")
        private List<Balance> balances;

        public State() {
        }

        public State(int version, String scriptHash, Boolean frozen, List<String> votes, List<Balance> balances) {
            this.version = version;
            this.scriptHash = scriptHash;
            this.frozen = frozen;
            this.votes = votes;
            this.balances = balances;
        }

        public int getVersion() {
            return this.version;
        }

        public String getScriptHash() {
            return this.scriptHash;
        }

        public Boolean getFrozen() {
            return this.frozen;
        }

        public List<String> getVotes() {
            return this.votes;
        }

        public List<Balance> getBalances() {
            return this.balances;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State state = (State)o;
            return this.getVersion() == state.getVersion() && Objects.equals(this.getScriptHash(), state.getScriptHash()) && Objects.equals(this.getFrozen(), state.getFrozen()) && Objects.equals(this.getVotes(), state.getVotes()) && Objects.equals(this.getBalances(), state.getBalances());
        }

        public int hashCode() {
            return Objects.hash(this.getVersion(), this.getScriptHash(), this.getFrozen(), this.getVotes(), this.getBalances());
        }

        public String toString() {
            return "State{version=" + this.version + ", scriptHash='" + this.scriptHash + '\'' + ", frozen=" + this.frozen + ", votes=" + this.votes + ", balances=" + this.balances + '}';
        }
    }
}

