/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.Response;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class NeoGetNep17Balances
extends Response<Balances> {
    public Balances getBalances() {
        return (Balances)this.getResult();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Nep17Balance {
        @JsonProperty(value="assethash")
        private String assetHash;
        @JsonProperty(value="amount")
        private String amount;
        @JsonProperty(value="lastupdatedblock")
        private BigInteger lastUpdatedBlock;

        public Nep17Balance() {
        }

        public Nep17Balance(String assetHash, String amount, BigInteger lastUpdatedBlock) {
            this.assetHash = assetHash;
            this.amount = amount;
            this.lastUpdatedBlock = lastUpdatedBlock;
        }

        public String getAssetHash() {
            return this.assetHash;
        }

        public String getAmount() {
            return this.amount;
        }

        public BigInteger getLastUpdatedBlock() {
            return this.lastUpdatedBlock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Nep17Balance)) {
                return false;
            }
            Nep17Balance that = (Nep17Balance)o;
            return Objects.equals(this.assetHash, that.assetHash) && Objects.equals(this.amount, that.amount) && Objects.equals(this.lastUpdatedBlock, that.lastUpdatedBlock);
        }

        public int hashCode() {
            return Objects.hash(this.assetHash, this.amount, this.lastUpdatedBlock);
        }

        public String toString() {
            return "Nep17Balance{assetHash='" + this.assetHash + '\'' + ", amount='" + this.amount + '\'' + ", lastUpdatedBlock=" + this.lastUpdatedBlock + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Balances {
        @JsonProperty(value="balance")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Nep17Balance> balances;
        @JsonProperty(value="address")
        private String address;

        public Balances() {
        }

        public Balances(List<Nep17Balance> balances, String address) {
            this.balances = balances;
            this.address = address;
        }

        public List<Nep17Balance> getBalances() {
            return this.balances;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Balances)) {
                return false;
            }
            Balances balances1 = (Balances)o;
            return Objects.equals(this.getBalances(), balances1.getBalances()) && Objects.equals(this.getAddress(), balances1.getAddress());
        }

        public int hashCode() {
            return Objects.hash(this.getBalances(), this.getAddress());
        }

        public String toString() {
            return "Balances{balances=" + this.balances + ", address='" + this.address + '\'' + '}';
        }
    }
}

