/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.Response;
import java.util.List;
import java.util.Objects;

public class NeoGetNep17Transfers
extends Response<Nep17TransferWrapper> {
    public Nep17TransferWrapper getNep17Transfer() {
        return (Nep17TransferWrapper)this.getResult();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Nep17Transfer {
        @JsonProperty(value="timestamp")
        private long timestamp;
        @JsonProperty(value="assethash")
        private String assetHash;
        @JsonProperty(value="transferaddress")
        private String transferAddress;
        @JsonProperty(value="amount")
        private String amount;
        @JsonProperty(value="blockindex")
        private long blockIndex;
        @JsonProperty(value="transfernotifyindex")
        private long transferNotifyIndex;
        @JsonProperty(value="txhash")
        private String txHash;

        public Nep17Transfer() {
        }

        public Nep17Transfer(long timestamp, String assetHash, String transferAddress, String amount, long blockIndex, long transferNotifyIndex, String txHash) {
            this.timestamp = timestamp;
            this.assetHash = assetHash;
            this.transferAddress = transferAddress;
            this.amount = amount;
            this.blockIndex = blockIndex;
            this.transferNotifyIndex = transferNotifyIndex;
            this.txHash = txHash;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getAssetHash() {
            return this.assetHash;
        }

        public String getTransferAddress() {
            return this.transferAddress;
        }

        public String getAmount() {
            return this.amount;
        }

        public long getBlockIndex() {
            return this.blockIndex;
        }

        public long getTransferNotifyIndex() {
            return this.transferNotifyIndex;
        }

        public String getTxHash() {
            return this.txHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Nep17Transfer)) {
                return false;
            }
            Nep17Transfer that = (Nep17Transfer)o;
            return this.getTimestamp() == that.getTimestamp() && this.getBlockIndex() == that.getBlockIndex() && this.getTransferNotifyIndex() == that.getTransferNotifyIndex() && Objects.equals(this.getAssetHash(), that.getAssetHash()) && Objects.equals(this.getTransferAddress(), that.getTransferAddress()) && Objects.equals(this.getAmount(), that.getAmount()) && Objects.equals(this.getTxHash(), that.getTxHash());
        }

        public int hashCode() {
            return Objects.hash(this.getTimestamp(), this.getAssetHash(), this.getTransferAddress(), this.getAmount(), this.getBlockIndex(), this.getTransferNotifyIndex(), this.getTxHash());
        }

        public String toString() {
            return "Nep17Transfer{timestamp=" + this.timestamp + ", assetHash='" + this.assetHash + '\'' + ", transferAddress='" + this.transferAddress + '\'' + ", amount='" + this.amount + '\'' + ", blockIndex=" + this.blockIndex + ", transferNotifyIndex=" + this.transferNotifyIndex + ", txHash='" + this.txHash + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Nep17TransferWrapper {
        @JsonProperty(value="sent")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Nep17Transfer> sent;
        @JsonProperty(value="received")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private List<Nep17Transfer> received;
        @JsonProperty(value="address")
        private String transferAddress;

        public Nep17TransferWrapper() {
        }

        public Nep17TransferWrapper(List<Nep17Transfer> sent, List<Nep17Transfer> received, String transferAddress) {
            this.sent = sent;
            this.received = received;
            this.transferAddress = transferAddress;
        }

        public List<Nep17Transfer> getSent() {
            return this.sent;
        }

        public List<Nep17Transfer> getReceived() {
            return this.received;
        }

        public String getTransferAddress() {
            return this.transferAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Nep17TransferWrapper)) {
                return false;
            }
            Nep17TransferWrapper that = (Nep17TransferWrapper)o;
            return Objects.equals(this.getSent(), that.getSent()) && Objects.equals(this.getReceived(), that.getReceived()) && Objects.equals(this.getTransferAddress(), that.getTransferAddress());
        }

        public int hashCode() {
            return Objects.hash(this.getSent(), this.getReceived(), this.getTransferAddress());
        }

        public String toString() {
            return "Nep17TransferWrapper{sent=" + this.sent + ", received=" + this.received + ", transferAddress='" + this.transferAddress + '\'' + '}';
        }
    }
}

