/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OracleResponseCode {
    SUCCESS("Success", 0),
    PROTOCOL_NOT_SUPPORTED("ProtocolNotSupported", 16),
    CONSENSUS_UNREACHABLE("ConsensusUnreachable", 18),
    NOT_FOUND("NotFound", 20),
    TIMEOUT("Timeout", 22),
    FORBIDDEN("Forbidden", 24),
    RESPONSE_TOO_LARGE("ResponseTooLarge", 26),
    INSUFFICIENT_FUNDS("InsufficientFunds", 28),
    ERROR("Error", 255);

    private String jsonValue;
    private byte byteValue;

    private OracleResponseCode(String jsonValue, int byteValue) {
        this.jsonValue = jsonValue;
        this.byteValue = (byte)byteValue;
    }

    @JsonCreator
    public static OracleResponseCode fromJson(Object value) {
        if (value instanceof String) {
            return OracleResponseCode.fromJsonValue((String)value);
        }
        if (value instanceof Integer) {
            return OracleResponseCode.valueOf(((Integer)value).byteValue());
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", OracleResponseCode.class.getName()));
    }

    public static OracleResponseCode valueOf(byte byteValue) {
        for (OracleResponseCode e : OracleResponseCode.values()) {
            if (e.byteValue != byteValue) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", OracleResponseCode.class.getName()));
    }

    public static OracleResponseCode fromJsonValue(String jsonValue) {
        for (OracleResponseCode e : OracleResponseCode.values()) {
            if (!e.jsonValue.equals(jsonValue)) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", OracleResponseCode.class.getName()));
    }

    public byte byteValue() {
        return this.byteValue;
    }

    @JsonValue
    public String jsonValue() {
        return this.jsonValue;
    }
}

