/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.protocol.core.methods.response.NeoWitness;
import io.neow3j.protocol.core.methods.response.TransactionAttribute;
import io.neow3j.protocol.core.methods.response.TransactionSigner;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Transaction {
    @JsonProperty(value="hash")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String hash;
    @JsonProperty(value="size")
    private long size;
    @JsonProperty(value="version")
    private int version;
    @JsonProperty(value="nonce")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long nonce;
    @JsonProperty(value="sender")
    private String sender;
    @JsonProperty(value="sysfee")
    private String sysFee;
    @JsonProperty(value="netfee")
    private String netFee;
    @JsonProperty(value="validuntilblock")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long validUntilBlock;
    @JsonProperty(value="signers")
    private List<TransactionSigner> signers;
    @JsonProperty(value="attributes")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<TransactionAttribute> attributes;
    @JsonProperty(value="script")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String script;
    @JsonProperty(value="witnesses")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private List<NeoWitness> witnesses;
    @JsonProperty(value="blockhash")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private String blockHash;
    @JsonProperty(value="confirmations")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private int confirmations;
    @JsonProperty(value="blocktime")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private long blockTime;
    @JsonProperty(value="vmstate")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private String vmState;

    public Transaction() {
    }

    public Transaction(String hash, long size, int version, Long nonce, String sender, String sysFee, String netFee, Long validUntilBlock, List<TransactionSigner> signers, List<TransactionAttribute> attributes, String script, List<NeoWitness> witnesses) {
        this.hash = hash;
        this.size = size;
        this.version = version;
        this.nonce = nonce;
        this.sender = sender;
        this.sysFee = sysFee;
        this.netFee = netFee;
        this.validUntilBlock = validUntilBlock;
        this.signers = signers;
        this.attributes = attributes;
        this.script = script;
        this.witnesses = witnesses;
    }

    public Transaction(String hash, long size, int version, Long nonce, String sender, String sysFee, String netFee, Long validUntilBlock, List<TransactionSigner> signers, List<TransactionAttribute> attributes, String script, List<NeoWitness> witnesses, String blockHash, int confirmations, long blockTime, String vmState) {
        this.hash = hash;
        this.size = size;
        this.version = version;
        this.nonce = nonce;
        this.sender = sender;
        this.sysFee = sysFee;
        this.netFee = netFee;
        this.validUntilBlock = validUntilBlock;
        this.signers = signers;
        this.attributes = attributes;
        this.script = script;
        this.witnesses = witnesses;
        this.blockHash = blockHash;
        this.confirmations = confirmations;
        this.blockTime = blockTime;
        this.vmState = vmState;
    }

    public String getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }

    public int getVersion() {
        return this.version;
    }

    public Long getNonce() {
        return this.nonce;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSysFee() {
        return this.sysFee;
    }

    public String getNetFee() {
        return this.netFee;
    }

    public Long getValidUntilBlock() {
        return this.validUntilBlock;
    }

    public List<TransactionSigner> getSigners() {
        return this.signers;
    }

    public List<TransactionAttribute> getAttributes() {
        return this.attributes;
    }

    public String getScript() {
        return this.script;
    }

    public List<NeoWitness> getWitnesses() {
        return this.witnesses;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public int getConfirmations() {
        return this.confirmations;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public String getVMState() {
        return this.vmState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.getSize() == that.getSize() && this.getVersion() == that.getVersion() && Objects.equals(this.getHash(), that.getHash()) && Objects.equals(this.getNonce(), that.getNonce()) && Objects.equals(this.getSender(), that.getSender()) && Objects.equals(this.getSysFee(), that.getSysFee()) && Objects.equals(this.getNetFee(), that.getNetFee()) && Objects.equals(this.getValidUntilBlock(), that.getValidUntilBlock()) && Objects.equals(this.getSigners(), that.getSigners()) && Objects.equals(this.getAttributes(), that.getAttributes()) && Objects.equals(this.getScript(), that.getScript()) && Objects.equals(this.getWitnesses(), that.getWitnesses()) && Objects.equals(this.getBlockHash(), that.getBlockHash()) && Objects.equals(this.getConfirmations(), that.getConfirmations()) && Objects.equals(this.getBlockTime(), that.getBlockTime()) && Objects.equals(this.getVMState(), that.getVMState());
    }

    public int hashCode() {
        return Objects.hash(this.getHash(), this.getSize(), this.getVersion(), this.getNonce(), this.getSender(), this.getSysFee(), this.getNetFee(), this.getValidUntilBlock(), this.getSigners(), this.getAttributes(), this.getScript(), this.getWitnesses(), this.getBlockHash(), this.getConfirmations(), this.getBlockTime(), this.getVMState());
    }

    public String toString() {
        return "Transaction{hash='" + this.hash + '\'' + ", size=" + this.size + ", version=" + this.version + ", nonce=" + this.nonce + ", sender='" + this.sender + '\'' + ", sysFee='" + this.sysFee + '\'' + ", netFee='" + this.netFee + '\'' + ", validUntilBlock=" + this.validUntilBlock + ", signers=" + this.signers + ", attributes=" + this.attributes + ", script='" + this.script + '\'' + ", witnesses=" + this.witnesses + ", blockHash=" + this.blockHash + ", confirmations=" + this.confirmations + ", blockTime=" + this.blockTime + ", vmState=" + this.vmState + '}';
    }
}

