/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.rx;

import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.BlockParameter;
import io.neow3j.protocol.core.BlockParameterIndex;
import io.neow3j.protocol.core.BlockParameterName;
import io.neow3j.protocol.core.methods.response.NeoBlockCount;
import io.neow3j.protocol.core.methods.response.NeoGetBlock;
import io.neow3j.protocol.core.methods.response.Transaction;
import io.neow3j.protocol.core.polling.BlockPolling;
import io.neow3j.utils.Observables;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposables;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;

public class JsonRpc2_0Rx {
    private final Neow3j neow3j;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Scheduler scheduler;

    public JsonRpc2_0Rx(Neow3j neow3j, ScheduledExecutorService scheduledExecutorService) {
        this.neow3j = neow3j;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduler = Schedulers.from((Executor)scheduledExecutorService);
    }

    public Observable<BigInteger> neoBlockObservable(long pollingInterval) {
        return Observable.create(subscriber -> {
            BlockPolling blockPolling = new BlockPolling(this.neow3j, arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0));
            blockPolling.run(this.scheduledExecutorService, pollingInterval);
            subscriber.setDisposable(Disposables.fromAction(blockPolling::cancel));
        });
    }

    public Observable<NeoGetBlock> replayBlocksObservable(BlockParameter startBlock, BlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, true);
    }

    public Observable<NeoGetBlock> replayBlocksObservable(BlockParameter startBlock, BlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, ascending).subscribeOn(this.scheduler);
    }

    private Observable<NeoGetBlock> replayBlocksObservableSync(BlockParameter startBlock, BlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, true);
    }

    private Observable<NeoGetBlock> replayBlocksObservableSync(BlockParameter startBlock, BlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        BigInteger startBlockNumber = null;
        BigInteger endBlockNumber = null;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            endBlockNumber = this.getBlockNumber(endBlock);
        }
        catch (IOException e) {
            Observable.error((Throwable)e);
        }
        if (ascending) {
            return Observables.range(startBlockNumber, endBlockNumber).flatMap(i -> this.neow3j.getBlock(new BlockParameterIndex((BigInteger)i), fullTransactionObjects).observable());
        }
        return Observables.range(startBlockNumber, endBlockNumber, false).flatMap(i -> this.neow3j.getBlock(new BlockParameterIndex((BigInteger)i), fullTransactionObjects).observable());
    }

    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BlockParameter startBlock, boolean fullTransactionObjects, Observable<NeoGetBlock> onCompleteObservable) {
        return this.catchUpToLatestBlockObservableSync(startBlock, fullTransactionObjects, onCompleteObservable).subscribeOn(this.scheduler);
    }

    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BlockParameter startBlock, boolean fullTransactionObjects) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, (Observable<NeoGetBlock>)Observable.empty());
    }

    private Observable<NeoGetBlock> catchUpToLatestBlockObservableSync(BlockParameter startBlock, boolean fullTransactionObjects, Observable<NeoGetBlock> onCompleteObservable) {
        BigInteger latestBlockNumber;
        BigInteger startBlockNumber;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            latestBlockNumber = this.getLatestBlockNumber();
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
        if (startBlockNumber.compareTo(latestBlockNumber) > -1) {
            return onCompleteObservable;
        }
        return Observable.concat(this.replayBlocksObservableSync(new BlockParameterIndex(startBlockNumber), new BlockParameterIndex(latestBlockNumber), fullTransactionObjects), (ObservableSource)Observable.defer(() -> this.catchUpToLatestBlockObservableSync(new BlockParameterIndex(latestBlockNumber.add(BigInteger.ONE)), fullTransactionObjects, onCompleteObservable)));
    }

    public Observable<Transaction> catchUpToLatestTransactionObservable(BlockParameter startBlock) {
        return this.catchUpToLatestBlockObservable(startBlock, true, (Observable<NeoGetBlock>)Observable.empty()).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<NeoGetBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(BlockParameter startBlock, boolean fullTransactionObjects, long pollingInterval) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, this.blockObservable(fullTransactionObjects, pollingInterval));
    }

    public Observable<NeoGetBlock> blockObservable(boolean fullTransactionObjects, long pollingInterval) {
        return this.neoBlockObservable(pollingInterval).flatMap(blockIndex -> this.neow3j.getBlock(new BlockParameterIndex((BigInteger)blockIndex), fullTransactionObjects).observable());
    }

    private static List<Transaction> toTransactions(NeoGetBlock neoGetBlock) {
        return neoGetBlock.getBlock().getTransactions().stream().collect(Collectors.toList());
    }

    private BigInteger getLatestBlockNumber() throws IOException {
        return this.getBlockNumber(BlockParameterName.LATEST).subtract(BigInteger.ONE);
    }

    private BigInteger getBlockNumber(BlockParameter defaultBlockParameter) throws IOException {
        if (defaultBlockParameter instanceof BlockParameterIndex) {
            return ((BlockParameterIndex)defaultBlockParameter).getBlockIndex();
        }
        if (defaultBlockParameter instanceof BlockParameterName && defaultBlockParameter.getValue() == BlockParameterName.EARLIEST.getValue()) {
            return BigInteger.ZERO;
        }
        NeoBlockCount latestNeoBlock = this.neow3j.getBlockCount().send();
        return latestNeoBlock.getBlockIndex();
    }
}

