/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.contract.ScriptBuilder;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.crypto.Sign;
import io.neow3j.io.BinaryReader;
import io.neow3j.io.BinaryWriter;
import io.neow3j.io.IOUtils;
import io.neow3j.io.NeoSerializable;
import io.neow3j.io.exceptions.DeserializationException;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class InvocationScript
extends NeoSerializable {
    private byte[] script;

    public InvocationScript() {
        this.script = new byte[0];
    }

    public InvocationScript(byte[] script) {
        this.script = script;
    }

    public static InvocationScript fromSignature(Sign.SignatureData signature) {
        byte[] script = new ScriptBuilder().pushData(signature.getConcatenated()).toArray();
        return new InvocationScript(script);
    }

    public static InvocationScript fromMessageAndKeyPair(byte[] message, ECKeyPair keyPair) {
        Sign.SignatureData signature = Sign.signMessage(message, keyPair);
        return InvocationScript.fromSignature(signature);
    }

    public static InvocationScript fromSignatures(List<Sign.SignatureData> sigs) {
        ScriptBuilder builder = new ScriptBuilder();
        sigs.forEach(sig -> builder.pushData(sig.getConcatenated()));
        return new InvocationScript(builder.toArray());
    }

    public byte[] getScript() {
        return this.script;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvocationScript)) {
            return false;
        }
        InvocationScript that = (InvocationScript)o;
        return Arrays.equals(this.getScript(), that.getScript());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getScript()});
    }

    public String toString() {
        return "InvocationScript{script=" + Numeric.toHexStringNoPrefix(this.script) + '}';
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.script = reader.readVarBytes();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(this.script);
    }

    @Override
    public int getSize() {
        return IOUtils.getVarSize(this.script.length) + this.script.length;
    }
}

