/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.contract.ScriptHash;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.io.BinaryReader;
import io.neow3j.io.BinaryWriter;
import io.neow3j.io.IOUtils;
import io.neow3j.io.NeoSerializable;
import io.neow3j.io.exceptions.DeserializationException;
import io.neow3j.transaction.WitnessScope;
import io.neow3j.transaction.exceptions.SignerConfigurationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Signer
extends NeoSerializable {
    private ScriptHash account;
    private List<WitnessScope> scopes;
    private List<ScriptHash> allowedContracts;
    private List<ECKeyPair.ECPublicKey> allowedGroups;

    public Signer() {
        this.account = new ScriptHash();
        this.scopes = new ArrayList<WitnessScope>();
        this.allowedContracts = new ArrayList<ScriptHash>();
        this.allowedGroups = new ArrayList<ECKeyPair.ECPublicKey>();
    }

    private Signer(Builder builder) {
        this.account = builder.account;
        this.scopes = builder.scopes;
        this.allowedContracts = builder.allowedContracts;
        this.allowedGroups = builder.allowedGroups;
    }

    public static Signer feeOnly(String address) {
        return new Builder().account(ScriptHash.fromAddress(address)).scopes(WitnessScope.NONE).build();
    }

    public static Signer feeOnly(ScriptHash account) {
        return new Builder().account(account).scopes(WitnessScope.NONE).build();
    }

    public static Signer calledByEntry(String address) {
        return new Builder().account(ScriptHash.fromAddress(address)).scopes(WitnessScope.CALLED_BY_ENTRY).build();
    }

    public static Signer calledByEntry(ScriptHash account) {
        return new Builder().account(account).scopes(WitnessScope.CALLED_BY_ENTRY).build();
    }

    public static Signer global(String address) {
        return new Builder().account(ScriptHash.fromAddress(address)).scopes(WitnessScope.GLOBAL).build();
    }

    public static Signer global(ScriptHash account) {
        return new Builder().account(account).scopes(WitnessScope.GLOBAL).build();
    }

    public ScriptHash getScriptHash() {
        return this.account;
    }

    public List<WitnessScope> getScopes() {
        return this.scopes;
    }

    public List<ScriptHash> getAllowedContracts() {
        return this.allowedContracts;
    }

    public List<ECKeyPair.ECPublicKey> getAllowedGroups() {
        return this.allowedGroups;
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.account = reader.readSerializable(ScriptHash.class);
            this.scopes = WitnessScope.extractCombinedScopes(reader.readByte());
            if (this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS)) {
                this.allowedContracts = reader.readSerializableList(ScriptHash.class);
                if (this.allowedContracts.size() > 16) {
                    throw new DeserializationException("A signer's scope can only contain 16 contracts. The input data contained " + this.allowedContracts.size() + " contracts.");
                }
            }
            if (this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS)) {
                this.allowedGroups = reader.readSerializableList(ECKeyPair.ECPublicKey.class);
                if (this.allowedGroups.size() > 16) {
                    throw new DeserializationException("A signer's scope can only contain 16 groups. The input data contained " + this.allowedGroups.size() + " groups.");
                }
            }
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeSerializableFixed(this.account);
        writer.writeByte(WitnessScope.combineScopes(this.scopes));
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS)) {
            writer.writeSerializableVariable(this.allowedContracts);
        }
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS)) {
            writer.writeSerializableVariable(this.allowedGroups);
        }
    }

    @Override
    public int getSize() {
        int size = 21;
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS)) {
            size += IOUtils.getVarSize(this.allowedContracts);
        }
        if (this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS)) {
            size += IOUtils.getVarSize(this.allowedGroups);
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signer that = (Signer)o;
        return Objects.equals(this.account, that.account) && Objects.equals(this.scopes, that.scopes) && Objects.equals(this.allowedContracts, that.allowedContracts) && Objects.equals(this.allowedGroups, that.allowedGroups);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.account, this.scopes, this.allowedContracts, this.allowedGroups);
    }

    public static class Builder {
        private ScriptHash account;
        private List<WitnessScope> scopes = new ArrayList<WitnessScope>();
        private List<ScriptHash> allowedContracts = new ArrayList<ScriptHash>();
        private List<ECKeyPair.ECPublicKey> allowedGroups = new ArrayList<ECKeyPair.ECPublicKey>();

        public Builder account(String address) {
            this.account = ScriptHash.fromAddress(address);
            return this;
        }

        public Builder account(ScriptHash account) {
            this.account = account;
            return this;
        }

        public Builder scopes(WitnessScope ... scopes) {
            this.scopes.addAll(Arrays.asList(scopes));
            return this;
        }

        public Builder allowedContracts(ScriptHash ... contracts) {
            if (!this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS)) {
                this.scopes.add(WitnessScope.CUSTOM_CONTRACTS);
            }
            if (this.allowedContracts.size() + contracts.length > 16) {
                throw new SignerConfigurationException("A signer's scope can only contain 16 contracts.");
            }
            this.allowedContracts.addAll(Arrays.asList(contracts));
            return this;
        }

        public Builder allowedGroups(ECKeyPair.ECPublicKey ... groups) {
            if (!this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS)) {
                this.scopes.add(WitnessScope.CUSTOM_GROUPS);
            }
            if (this.allowedGroups.size() + groups.length > 16) {
                throw new SignerConfigurationException("A signer's scope can only contain 16 groups.");
            }
            this.allowedGroups.addAll(Arrays.asList(groups));
            return this;
        }

        public Signer build() {
            if (this.account == null) {
                throw new SignerConfigurationException("No account has been set. A signer object requires an account.");
            }
            if (this.scopes.isEmpty()) {
                throw new SignerConfigurationException("No scope has been defined. A signer object requires at least one scope.");
            }
            if (this.scopes.contains((Object)WitnessScope.NONE) && this.scopes.size() > 1) {
                throw new SignerConfigurationException("The fee-only witness scope cannot be combined with other scopes.");
            }
            if (this.scopes.contains((Object)WitnessScope.GLOBAL) && this.scopes.size() > 1) {
                throw new SignerConfigurationException("The global witness scope cannot be combined with other scopes.");
            }
            if (this.scopes.contains((Object)WitnessScope.CUSTOM_CONTRACTS) && this.allowedContracts.isEmpty()) {
                throw new SignerConfigurationException("Set of allowed contracts must not be empty for a signer with the custom contracts scope.");
            }
            if (this.scopes.contains((Object)WitnessScope.CUSTOM_GROUPS) && this.allowedGroups.isEmpty()) {
                throw new SignerConfigurationException("Set of allowed groups must not be empty for a signer with the custom groups scope.");
            }
            return new Signer(this);
        }
    }
}

