/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.contract.ScriptHash;
import io.neow3j.crypto.Hash;
import io.neow3j.io.BinaryReader;
import io.neow3j.io.BinaryWriter;
import io.neow3j.io.IOUtils;
import io.neow3j.io.NeoSerializable;
import io.neow3j.io.exceptions.DeserializationException;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.BlockParameterIndex;
import io.neow3j.protocol.core.methods.response.NeoApplicationLog;
import io.neow3j.protocol.core.methods.response.NeoSendRawTransaction;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionAttribute;
import io.neow3j.transaction.Witness;
import io.neow3j.transaction.WitnessScope;
import io.neow3j.transaction.exceptions.TransactionConfigurationException;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import io.reactivex.Observable;
import io.reactivex.functions.Predicate;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Transaction
extends NeoSerializable {
    public static final int HEADER_SIZE = 25;
    protected Neow3j neow;
    private byte version;
    private long nonce;
    private long validUntilBlock;
    private List<Signer> signers;
    private long systemFee;
    private long networkFee;
    private List<TransactionAttribute> attributes;
    private byte[] script;
    private List<Witness> witnesses;
    private BigInteger blockIndexWhenSent;

    public Transaction() {
        this.signers = new ArrayList<Signer>();
        this.attributes = new ArrayList<TransactionAttribute>();
        this.witnesses = new ArrayList<Witness>();
    }

    public Transaction(Neow3j neow, byte version, long nonce, long validUntilBlock, List<Signer> signers, long systemFee, long networkFee, List<TransactionAttribute> attributes, byte[] script, List<Witness> witnesses) {
        this.neow = neow;
        this.version = version;
        this.nonce = nonce;
        this.validUntilBlock = validUntilBlock;
        this.signers = signers;
        this.systemFee = systemFee;
        this.networkFee = networkFee;
        this.attributes = attributes;
        this.script = script;
        this.witnesses = witnesses;
    }

    public byte getVersion() {
        return this.version;
    }

    public long getNonce() {
        return this.nonce;
    }

    public long getValidUntilBlock() {
        return this.validUntilBlock;
    }

    public List<Signer> getSigners() {
        return this.signers;
    }

    public ScriptHash getSender() {
        return this.signers.stream().filter(signer -> signer.getScopes().contains((Object)WitnessScope.NONE)).findFirst().orElse(this.signers.get(0)).getScriptHash();
    }

    public long getSystemFee() {
        return this.systemFee;
    }

    public long getNetworkFee() {
        return this.networkFee;
    }

    public List<TransactionAttribute> getAttributes() {
        return this.attributes;
    }

    public byte[] getScript() {
        return this.script;
    }

    public List<Witness> getWitnesses() {
        return this.witnesses;
    }

    public void addWitness(Witness witness) {
        if (witness.getScriptHash() == null) {
            throw new IllegalArgumentException("The script hash of the given witness must not be null.");
        }
        this.witnesses.add(witness);
    }

    public String getTxId() throws IOException {
        byte[] hash = Hash.hash256(this.getHashData());
        return Numeric.toHexStringNoPrefix(ArrayUtils.reverseArray(hash));
    }

    public NeoSendRawTransaction send() throws IOException {
        if (this.getSigners().size() != this.getWitnesses().size()) {
            throw new TransactionConfigurationException("The transaction does not have the same number of signers and witnesses. For every signer there has to be one witness, even if that witness is empty.");
        }
        String hex = Numeric.toHexStringNoPrefix(this.toArray());
        this.blockIndexWhenSent = this.neow.getBlockCount().send().getBlockIndex();
        return this.neow.sendRawTransaction(hex).send();
    }

    public Observable<Long> track() {
        if (this.blockIndexWhenSent == null) {
            throw new IllegalStateException("Can't subscribe before transaction has been sent.");
        }
        Predicate pred = neoGetBlock -> neoGetBlock.getBlock().getTransactions() != null && neoGetBlock.getBlock().getTransactions().stream().anyMatch(transaction -> {
            try {
                return Numeric.cleanHexPrefix(transaction.getHash()).equals(this.getTxId());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return this.neow.catchUpToLatestAndSubscribeToNewBlocksObservable(new BlockParameterIndex(this.blockIndexWhenSent), true).takeUntil(pred).filter(pred).map(neoGetBlock -> neoGetBlock.getBlock().getIndex());
    }

    public NeoApplicationLog getApplicationLog() {
        if (this.blockIndexWhenSent == null) {
            throw new IllegalStateException("Can't get the application log before transaction has been sent.");
        }
        NeoApplicationLog applicationLog = null;
        try {
            applicationLog = this.neow.getApplicationLog(this.getTxId()).send().getApplicationLog();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return applicationLog;
    }

    @Override
    public int getSize() {
        return 25 + IOUtils.getVarSize(this.signers) + IOUtils.getVarSize(this.attributes) + IOUtils.getVarSize(this.script) + IOUtils.getVarSize(this.witnesses);
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.version = reader.readByte();
            this.nonce = reader.readUInt32();
            this.systemFee = reader.readInt64();
            this.networkFee = reader.readInt64();
            this.validUntilBlock = reader.readUInt32();
            this.signers = reader.readSerializableList(Signer.class);
            this.readTransactionAttributes(reader);
            this.script = reader.readVarBytes();
            this.witnesses = reader.readSerializableList(Witness.class);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    private void readTransactionAttributes(BinaryReader reader) throws IOException, DeserializationException {
        long nrOfAttributes = reader.readVarInt();
        if (nrOfAttributes > 16L) {
            throw new DeserializationException("A transaction can hold at most 16. Input data had " + nrOfAttributes + " attributes.");
        }
        int i = 0;
        while ((long)i < nrOfAttributes) {
            this.attributes.add(TransactionAttribute.deserializeAttribute(reader));
            ++i;
        }
    }

    private void serializeWithoutWitnesses(BinaryWriter writer) throws IOException {
        writer.writeByte(this.version);
        writer.writeUInt32(this.nonce);
        writer.writeInt64(this.systemFee);
        writer.writeInt64(this.networkFee);
        writer.writeUInt32(this.validUntilBlock);
        writer.writeSerializableVariable(this.signers);
        writer.writeSerializableVariable(this.attributes);
        writer.writeVarBytes(this.script);
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        this.serializeWithoutWitnesses(writer);
        writer.writeSerializableVariable(this.witnesses);
    }

    /*
     * Exception decompiling
     */
    public byte[] toArrayWithoutWitnesses() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getHashData() throws IOException {
        return ArrayUtils.concatenate(this.neow.getNetworkMagicNumber(), this.toArrayWithoutWitnesses());
    }

    @Override
    public byte[] toArray() {
        return super.toArray();
    }
}

