/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.Hash;
import io.neow3j.crypto.exceptions.AddressFormatException;
import io.neow3j.protocol.Neow3j;
import io.neow3j.utils.ArrayUtils;

public class AddressUtils {
    public static boolean isValidAddress(String address) {
        byte[] data;
        try {
            data = Base58.decode(address);
        }
        catch (AddressFormatException e) {
            return false;
        }
        if (data.length != 25) {
            return false;
        }
        if (data[0] != Neow3j.getAddressVersion()) {
            return false;
        }
        byte[] checksum = Hash.hash256(data, 0, 21);
        for (int i = 0; i < 4; ++i) {
            if (data[data.length - 4 + i] == checksum[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] addressToScriptHash(String address) {
        if (!AddressUtils.isValidAddress(address)) {
            throw new IllegalArgumentException("Not a valid NEO address.");
        }
        byte[] data = Base58.decode(address);
        byte[] buffer = new byte[20];
        System.arraycopy(data, 1, buffer, 0, 20);
        return buffer;
    }

    public static String scriptHashToAddress(byte[] scriptHash) {
        byte[] script = ArrayUtils.concatenate(Neow3j.getAddressVersion(), scriptHash);
        byte[] checksum = ArrayUtils.getFirstNBytes(Hash.hash256(script), 4);
        return Base58.encode(ArrayUtils.concatenate(script, checksum));
    }
}

