/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.contract.ScriptHash;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.methods.response.NeoGetContractState;
import io.neow3j.protocol.core.methods.response.NeoGetNep17Balances;
import io.neow3j.protocol.core.methods.response.NeoGetTransactionHeight;
import io.neow3j.protocol.core.methods.response.NeoGetWalletBalance;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class Await {
    private static final int MAX_WAIT_TIME = 30;

    public static void waitUntilBalancesIsGreaterThanZero(String address, ScriptHash token, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetBalance(address, token, neow3j), Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    public static void waitUntilContractIsDeployed(ScriptHash contract, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetContractState(contract, neow3j), Matchers.is((Object)true));
    }

    public static void waitUntilTransactionIsExecuted(String txHash, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetTxHash(txHash, neow3j), Matchers.notNullValue());
    }

    public static void waitUntilOpenWalletHasBalanceGreaterThanOrEqualTo(String amount, ScriptHash token, Neow3j neow3j) {
        Await.waitUntil(Await.callableGetBalance(token, neow3j), Matchers.greaterThanOrEqualTo((Comparable)new BigDecimal(amount)));
    }

    private static <T> void waitUntil(Callable<T> callable, Matcher<? super T> matcher) {
        Awaitility.await().timeout(30L, TimeUnit.SECONDS).until(callable, matcher);
    }

    private static Callable<Boolean> callableGetContractState(ScriptHash contractScriptHash, Neow3j neow3j) {
        return () -> {
            try {
                NeoGetContractState response = neow3j.getContractState(contractScriptHash.toString()).send();
                if (response.hasError()) {
                    return false;
                }
                return response.getContractState().getHash().equals("0x" + contractScriptHash.toString());
            }
            catch (IOException e) {
                return false;
            }
        };
    }

    private static Callable<Long> callableGetBalance(String address, ScriptHash tokenScriptHash, Neow3j neow3j) {
        return () -> {
            try {
                List<NeoGetNep17Balances.Nep17Balance> balances = neow3j.getNep17Balances(address).send().getBalances().getBalances();
                return balances.stream().filter(b -> b.getAssetHash().equals("0x" + tokenScriptHash.toString())).findFirst().map(b -> Long.valueOf(b.getAmount())).orElse(0L);
            }
            catch (IOException e) {
                return 0L;
            }
        };
    }

    private static Callable<Long> callableGetTxHash(String txHash, Neow3j neow3j) {
        return () -> {
            try {
                NeoGetTransactionHeight tx = neow3j.getTransactionHeight(txHash).send();
                if (tx.hasError()) {
                    return null;
                }
                return tx.getHeight().longValue();
            }
            catch (IOException e) {
                return null;
            }
        };
    }

    private static Callable<BigDecimal> callableGetBalance(ScriptHash token, Neow3j neow3j) {
        return () -> {
            try {
                NeoGetWalletBalance response = neow3j.getWalletBalance(token.toString()).send();
                String balance = response.getWalletBalance().getBalance();
                return new BigDecimal(balance);
            }
            catch (IOException e) {
                return BigDecimal.ZERO;
            }
        };
    }
}

