/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.wallet.nep6;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.model.types.ContractParameterType;
import java.util.List;
import java.util.Objects;

public class NEP6Contract {
    @JsonProperty(value="script")
    private String script;
    @JsonProperty(value="parameters")
    private List<NEP6Parameter> nep6Parameters;
    @JsonProperty(value="deployed")
    private Boolean deployed;

    public NEP6Contract() {
    }

    public NEP6Contract(String script, List<NEP6Parameter> nep6Parameters, Boolean deployed) {
        this.script = script;
        this.nep6Parameters = nep6Parameters;
        this.deployed = deployed;
    }

    public String getScript() {
        return this.script;
    }

    public List<NEP6Parameter> getParameters() {
        return this.nep6Parameters;
    }

    public Boolean getDeployed() {
        return this.deployed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NEP6Contract)) {
            return false;
        }
        NEP6Contract contract = (NEP6Contract)o;
        return Objects.equals(this.getScript(), contract.getScript()) && Objects.equals(this.getParameters(), contract.getParameters()) && Objects.equals(this.getDeployed(), contract.getDeployed());
    }

    public int hashCode() {
        return Objects.hash(this.getScript(), this.getParameters(), this.getDeployed());
    }

    public String toString() {
        return "Contract{script='" + this.script + '\'' + ", nep6Parameters=" + this.nep6Parameters + ", deployed=" + this.deployed + '}';
    }

    public static class NEP6Parameter {
        @JsonProperty(value="name")
        private String paramName;
        @JsonProperty(value="type")
        private ContractParameterType paramType;

        public NEP6Parameter(String paramName, ContractParameterType paramType) {
            this.paramName = paramName;
            this.paramType = paramType;
        }

        public NEP6Parameter() {
        }

        public String getParamName() {
            return this.paramName;
        }

        public ContractParameterType getParamType() {
            return this.paramType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NEP6Parameter nep6Parameter = (NEP6Parameter)o;
            return Objects.equals(this.paramName, nep6Parameter.paramName) && this.paramType == nep6Parameter.paramType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.paramName, this.paramType});
        }

        public String toString() {
            return "NEP6Parameter{paramName='" + this.paramName + '\'' + ", paramType=" + (Object)((Object)this.paramType) + '}';
        }
    }
}

