/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.seata.common.XID;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.ConfigurationFactory;
import io.seata.core.rpc.RemotingBootstrap;
import io.seata.core.rpc.netty.NettyServerConfig;
import io.seata.core.rpc.netty.v1.ProtocolV1Decoder;
import io.seata.core.rpc.netty.v1.ProtocolV1Encoder;
import io.seata.discovery.registry.MultiRegistryFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerBootstrap
implements RemotingBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServerBootstrap.class);
    private final ServerBootstrap serverBootstrap = new ServerBootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final EventLoopGroup eventLoopGroupBoss;
    private final NettyServerConfig nettyServerConfig;
    private ChannelHandler[] channelHandlers;
    private int listenPort;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public NettyServerBootstrap(NettyServerConfig nettyServerConfig) {
        this.nettyServerConfig = nettyServerConfig;
        if (NettyServerConfig.enableEpoll()) {
            this.eventLoopGroupBoss = new EpollEventLoopGroup(nettyServerConfig.getBossThreadSize(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getBossThreadPrefix(), nettyServerConfig.getBossThreadSize()));
            this.eventLoopGroupWorker = new EpollEventLoopGroup(nettyServerConfig.getServerWorkerThreads(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getWorkerThreadPrefix(), nettyServerConfig.getServerWorkerThreads()));
        } else {
            this.eventLoopGroupBoss = new NioEventLoopGroup(nettyServerConfig.getBossThreadSize(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getBossThreadPrefix(), nettyServerConfig.getBossThreadSize()));
            this.eventLoopGroupWorker = new NioEventLoopGroup(nettyServerConfig.getServerWorkerThreads(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getWorkerThreadPrefix(), nettyServerConfig.getServerWorkerThreads()));
        }
    }

    protected void setChannelHandlers(ChannelHandler ... handlers) {
        if (handlers != null) {
            this.channelHandlers = handlers;
        }
    }

    private void addChannelPipelineLast(Channel channel, ChannelHandler ... handlers) {
        if (channel != null && handlers != null) {
            channel.pipeline().addLast(handlers);
        }
    }

    public void setListenPort(int listenPort) {
        if (listenPort <= 0) {
            throw new IllegalArgumentException("listen port: " + listenPort + " is invalid!");
        }
        this.listenPort = listenPort;
    }

    public int getListenPort() {
        if (this.listenPort != 0) {
            return this.listenPort;
        }
        String strPort = ConfigurationFactory.getInstance().getConfig("server.servicePort");
        int port = 0;
        try {
            port = Integer.parseInt(strPort);
        }
        catch (NumberFormatException exx) {
            LOGGER.error("server service port set error:{}", (Object)exx.getMessage());
        }
        if (port <= 0) {
            LOGGER.error("listen port: {} is invalid, will use default port:{}", (Object)port, (Object)8091);
            port = 8091;
        }
        this.listenPort = port;
        return port;
    }

    @Override
    public void start() {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupWorker).channel(NettyServerConfig.SERVER_CHANNEL_CLAZZ)).option(ChannelOption.SO_BACKLOG, (Object)this.nettyServerConfig.getSoBackLogSize())).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)this.nettyServerConfig.getServerSocketSendBufSize()).childOption(ChannelOption.SO_RCVBUF, (Object)this.nettyServerConfig.getServerSocketResvBufSize()).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyServerConfig.getWriteBufferLowWaterMark(), this.nettyServerConfig.getWriteBufferHighWaterMark())).localAddress((SocketAddress)new InetSocketAddress(this.getListenPort()))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(NettyServerBootstrap.this.nettyServerConfig.getChannelMaxReadIdleSeconds(), 0, 0)}).addLast(new ChannelHandler[]{new ProtocolV1Decoder()}).addLast(new ChannelHandler[]{new ProtocolV1Encoder()});
                if (NettyServerBootstrap.this.channelHandlers != null) {
                    NettyServerBootstrap.this.addChannelPipelineLast((Channel)ch, NettyServerBootstrap.this.channelHandlers);
                }
            }
        });
        try {
            this.serverBootstrap.bind(this.getListenPort()).sync();
            LOGGER.info("Server started, service listen port: {}", (Object)this.getListenPort());
            InetSocketAddress address = new InetSocketAddress(XID.getIpAddress(), XID.getPort());
            for (RegistryService registryService : MultiRegistryFactory.getInstances()) {
                registryService.register(address);
            }
            this.initialized.set(true);
        }
        catch (SocketException se) {
            throw new RuntimeException("Server start failed, the listen port: " + this.getListenPort(), se);
        }
        catch (Exception exx) {
            throw new RuntimeException("Server start failed", exx);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Shutting server down, the listen port: {}", (Object)XID.getPort());
            }
            if (this.initialized.get()) {
                InetSocketAddress address = new InetSocketAddress(XID.getIpAddress(), XID.getPort());
                for (RegistryService registryService : MultiRegistryFactory.getInstances()) {
                    registryService.unregister(address);
                    registryService.close();
                }
                TimeUnit.SECONDS.sleep(this.nettyServerConfig.getServerShutdownWaitTime());
            }
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupWorker.shutdownGracefully();
        }
        catch (Exception exx) {
            LOGGER.error("shutdown execute error: {}", (Object)exx.getMessage(), (Object)exx);
        }
    }
}

