/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db.sql.lock;

import io.seata.common.exception.NotSupportYetException;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.db.sql.lock.LockStoreSql;
import java.util.ArrayList;
import java.util.List;

public class AbstractLockStoreSql
implements LockStoreSql {
    private static final int MAX_IN_SIZE = 1000;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected static final String LOCK_TABLE_PLACE_HOLD = " #lock_table# ";
    protected static final String WHERE_PLACE_HOLD = " #where# ";
    protected static final String IN_PARAMS_PLACE_HOLD = " #in_params# ";
    protected static final String LOCK_TABLE_PK_WHERE_CONDITION_PLACE_HOLD = " #lock_table_pk_where_condition# ";
    protected static final String LOCK_TABLE_BRANCH_ID_WHERE_CONDITION_PLACE_HOLD = " #lock_table_branch_id_where_condition# ";
    protected static final String ALL_COLUMNS = "xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified,status";
    private static final String DELETE_LOCK_SQL = "delete from  #lock_table#  where row_key = ? and xid = ?";
    private static final String BATCH_DELETE_LOCK_SQL = "delete from  #lock_table#  where xid = ? and ( #lock_table_pk_where_condition# ) ";
    private static final String BATCH_DELETE_LOCK_BY_BRANCH_ID_SQL = "delete from  #lock_table#  where branch_id = ? ";
    private static final String BATCH_UPDATE_STATUS_LOCK_BY_GLOBAL_SQL = "update  #lock_table#  set status = ? where xid = ? ";
    private static final String BATCH_DELETE_LOCK_BY_BRANCHS_SQL = "delete from  #lock_table#  where xid = ? ";
    private static final String QUERY_LOCK_SQL = "select xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified,status from  #lock_table#  where row_key = ? ";
    private static final String CHECK_LOCK_SQL = "select xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified,status from  #lock_table#  where  #lock_table_pk_where_condition#  order by status desc ";
    private static final String QUERY_ALL_LOCK = "select xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified,status from  #lock_table#  #where#  order by gmt_create desc ";

    @Override
    public String getAllLockSql(String lockTable, String whereCondition) {
        return QUERY_ALL_LOCK.replace(LOCK_TABLE_PLACE_HOLD, lockTable).replace(WHERE_PLACE_HOLD, whereCondition);
    }

    @Override
    public String getInsertLockSQL(String lockTable) {
        throw new NotSupportYetException("unknown dbType:" + CONFIG.getConfig("store.db.dbType"));
    }

    @Override
    public String getDeleteLockSql(String lockTable) {
        return DELETE_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    @Override
    public String getBatchDeleteLockSql(String lockTable, int rowSize) {
        ArrayList<String> pkNameList = new ArrayList<String>();
        pkNameList.add("row_key");
        String whereCondition = this.buildWhereConditionByPKs(pkNameList, rowSize, 1000);
        return BATCH_DELETE_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable).replace(LOCK_TABLE_PK_WHERE_CONDITION_PLACE_HOLD, whereCondition);
    }

    @Override
    public String getBatchDeleteLockSqlByBranchId(String lockTable) {
        return BATCH_DELETE_LOCK_BY_BRANCH_ID_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    @Override
    public String getBatchDeleteLockSqlByXid(String lockTable) {
        return BATCH_DELETE_LOCK_BY_BRANCHS_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    @Override
    public String getQueryLockSql(String lockTable) {
        return QUERY_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    @Override
    public String getCheckLockableSql(String lockTable, int rowSize) {
        ArrayList<String> pkNameList = new ArrayList<String>();
        pkNameList.add("row_key");
        String whereCondition = this.buildWhereConditionByPKs(pkNameList, rowSize, 1000);
        return CHECK_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable).replace(LOCK_TABLE_PK_WHERE_CONDITION_PLACE_HOLD, whereCondition);
    }

    @Override
    public String getBatchUpdateStatusLockByGlobalSql(String lockTable) {
        return BATCH_UPDATE_STATUS_LOCK_BY_GLOBAL_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    private String buildWhereConditionByPKs(List<String> pkNameList, int rowSize, int maxInSize) {
        StringBuilder whereStr = new StringBuilder();
        int batchSize = rowSize % maxInSize == 0 ? rowSize / maxInSize : rowSize / maxInSize + 1;
        for (int batch = 0; batch < batchSize; ++batch) {
            if (batch > 0) {
                whereStr.append(" or ");
            }
            if (pkNameList.size() > 1) {
                whereStr.append("(");
            }
            for (int i = 0; i < pkNameList.size(); ++i) {
                if (i > 0) {
                    whereStr.append(",");
                }
                whereStr.append(pkNameList.get(i));
            }
            if (pkNameList.size() > 1) {
                whereStr.append(")");
            }
            whereStr.append(" in ( ");
            int eachSize = batch == batchSize - 1 ? (rowSize % maxInSize == 0 ? maxInSize : rowSize % maxInSize) : maxInSize;
            for (int i = 0; i < eachSize; ++i) {
                if (i > 0) {
                    whereStr.append(",");
                }
                if (pkNameList.size() > 1) {
                    whereStr.append("(");
                }
                for (int x = 0; x < pkNameList.size(); ++x) {
                    if (x > 0) {
                        whereStr.append(",");
                    }
                    whereStr.append("?");
                }
                if (pkNameList.size() <= 1) continue;
                whereStr.append(")");
            }
            whereStr.append(" )");
        }
        return whereStr.toString();
    }
}

