/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.brpc;

import com.baidu.brpc.RpcContext;
import com.baidu.brpc.interceptor.AbstractInterceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import io.seata.core.context.RootContext;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionPropagationClientInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionPropagationClientInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundProcess(Request brpcRequest, Response brpcResponse, InterceptorChain chain) throws Exception {
        String xid = RootContext.getXID();
        String rpcXid = this.getRpcXid();
        HashMap<String, String> kvAttachment = brpcRequest.getKvAttachment();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SEATA-BRPC[{}]: xid in RootContext[{}] xid in RpcContext[{}]", new Object[]{RootContext.getBranchType(), xid, rpcXid});
        }
        if (null != xid) {
            if (null == kvAttachment) {
                kvAttachment = new HashMap<String, String>();
            }
            kvAttachment.put("TX_XID", xid);
            if (null != RootContext.getBranchType()) {
                kvAttachment.put("TX_BRANCH_TYPE", RootContext.getBranchType().name());
            }
            brpcRequest.setKvAttachment(kvAttachment);
        }
        try {
            chain.intercept(brpcRequest, brpcResponse);
        }
        finally {
            Map requestAttachment = brpcRequest.getKvAttachment();
            if (null != requestAttachment) {
                requestAttachment.remove("TX_XID");
                requestAttachment.remove("TX_BRANCH_TYPE");
            }
        }
    }

    private String getRpcXid() {
        RpcContext context = RpcContext.getContext();
        Map requestKvAttachmentMap = context.getRequestKvAttachment();
        if (null == requestKvAttachmentMap) {
            return null;
        }
        return (String)requestKvAttachmentMap.get("TX_XID");
    }
}

