/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.rm.datasource.sql.struct.Field;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class SqlGenerateUtils {
    private static final int MAX_IN_SIZE = 1000;

    private SqlGenerateUtils() {
    }

    public static String buildWhereConditionByPKs(List<String> pkNameList, int rowSize, String dbType) throws SQLException {
        return SqlGenerateUtils.buildWhereConditionByPKs(pkNameList, rowSize, dbType, 1000);
    }

    public static String buildWhereConditionByPKs(List<String> pkNameList, int rowSize, String dbType, int maxInSize) throws SQLException {
        StringBuilder whereStr = new StringBuilder();
        int batchSize = rowSize % maxInSize == 0 ? rowSize / maxInSize : rowSize / maxInSize + 1;
        for (int batch = 0; batch < batchSize; ++batch) {
            if (batch > 0) {
                whereStr.append(" or ");
            }
            whereStr.append("(");
            for (int i = 0; i < pkNameList.size(); ++i) {
                if (i > 0) {
                    whereStr.append(",");
                }
                whereStr.append(ColumnUtils.addEscape(pkNameList.get(i), dbType));
            }
            whereStr.append(") in ( ");
            int eachSize = batch == batchSize - 1 ? (rowSize % maxInSize == 0 ? maxInSize : rowSize % maxInSize) : maxInSize;
            for (int i = 0; i < eachSize; ++i) {
                if (i > 0) {
                    whereStr.append(",");
                }
                whereStr.append("(");
                for (int x = 0; x < pkNameList.size(); ++x) {
                    if (x > 0) {
                        whereStr.append(",");
                    }
                    whereStr.append("?");
                }
                whereStr.append(")");
            }
            whereStr.append(" )");
        }
        return whereStr.toString();
    }

    public static void setParamForPk(List<Map<String, Field>> pkRowsList, List<String> pkColumnNameList, PreparedStatement pst) throws SQLException {
        int paramIndex = 1;
        for (int i = 0; i < pkRowsList.size(); ++i) {
            Map<String, Field> rowData = pkRowsList.get(i);
            for (String columnName : pkColumnNameList) {
                Field pkField = rowData.get(columnName);
                pst.setObject(paramIndex, pkField.getValue(), pkField.getType());
                ++paramIndex;
            }
        }
    }

    public static String buildWhereConditionByPKs(List<String> pkNameList, String dbType) {
        StringBuilder whereStr = new StringBuilder();
        for (int i = 0; i < pkNameList.size(); ++i) {
            if (i > 0) {
                whereStr.append(" and ");
            }
            String pkName = pkNameList.get(i);
            whereStr.append(ColumnUtils.addEscape(pkName, dbType));
            whereStr.append(" = ? ");
        }
        return whereStr.toString();
    }
}

