/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.util;

import org.springframework.aop.Advisor;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.OrderUtils;

public class OrderUtil {
    private OrderUtil() {
    }

    public static int getOrder(Object obj) {
        if (obj instanceof Ordered) {
            return ((Ordered)obj).getOrder();
        }
        Integer order = OrderUtils.getOrder(obj.getClass());
        return order == null ? Integer.MAX_VALUE : order;
    }

    public static boolean lowerThan(Integer source, Integer target) {
        if (source == null) {
            source = Integer.MAX_VALUE;
        }
        if (target == null) {
            target = Integer.MAX_VALUE;
        }
        return source > target;
    }

    public static boolean higherThan(Integer source, Integer target) {
        if (source == null) {
            source = Integer.MAX_VALUE;
        }
        if (target == null) {
            target = Integer.MAX_VALUE;
        }
        return source < target;
    }

    public static boolean lowerOrEquals(Integer source, Integer target) {
        if (source == null) {
            source = Integer.MAX_VALUE;
        }
        if (target == null) {
            target = Integer.MAX_VALUE;
        }
        return source >= target;
    }

    public static boolean higherOrEquals(Integer source, Integer target) {
        if (source == null) {
            source = Integer.MAX_VALUE;
        }
        if (target == null) {
            target = Integer.MAX_VALUE;
        }
        return source <= target;
    }

    public static boolean lowerThan(Class<?> source, Class<?> target) {
        return source.getSimpleName().compareTo(target.getSimpleName()) > 0;
    }

    public static boolean higherThan(Class<?> source, Class<?> target) {
        return source.getSimpleName().compareTo(target.getSimpleName()) < 0;
    }

    public static boolean lowerOrEquals(Class<?> source, Class<?> target) {
        return source.getSimpleName().compareTo(target.getSimpleName()) >= 0;
    }

    public static boolean higherOrEquals(Class<?> source, Class<?> target) {
        return source.getSimpleName().compareTo(target.getSimpleName()) <= 0;
    }

    public static boolean lowerThan(Advisor source, Advisor target) {
        int sourceOrder = OrderUtil.getOrder(source);
        int targetOrder = OrderUtil.getOrder(target);
        if (OrderUtil.lowerThan(sourceOrder, targetOrder)) {
            return true;
        }
        return sourceOrder == targetOrder && OrderUtil.lowerThan(source.getAdvice().getClass(), target.getAdvice().getClass());
    }

    public static boolean higherThan(Advisor source, Advisor target) {
        int sourceOrder = OrderUtil.getOrder(source);
        int targetOrder = OrderUtil.getOrder(target);
        if (OrderUtil.higherThan(sourceOrder, targetOrder)) {
            return true;
        }
        return sourceOrder == targetOrder && OrderUtil.higherThan(source.getAdvice().getClass(), target.getAdvice().getClass());
    }

    public static boolean lowerOrEquals(Advisor source, Advisor target) {
        int sourceOrder = OrderUtil.getOrder(source);
        int targetOrder = OrderUtil.getOrder(target);
        if (OrderUtil.lowerThan(sourceOrder, targetOrder)) {
            return true;
        }
        return sourceOrder == targetOrder && OrderUtil.lowerOrEquals(source.getAdvice().getClass(), target.getAdvice().getClass());
    }

    public static boolean higherOrEquals(Advisor source, Advisor target) {
        int sourceOrder = OrderUtil.getOrder(source);
        int targetOrder = OrderUtil.getOrder(target);
        if (OrderUtil.higherThan(sourceOrder, targetOrder)) {
            return true;
        }
        return sourceOrder == targetOrder && OrderUtil.higherOrEquals(source.getAdvice().getClass(), target.getAdvice().getClass());
    }

    public static int lower(Integer orderSource, int offset) {
        if (offset <= 0) {
            throw new IllegalArgumentException("offset must be greater than 0");
        }
        if (orderSource == null) {
            orderSource = Integer.MAX_VALUE;
        }
        if (Integer.MAX_VALUE - offset < orderSource) {
            return Integer.MAX_VALUE;
        }
        return orderSource + offset;
    }

    public static int higher(Integer orderSource, int offset) {
        if (offset <= 0) {
            throw new IllegalArgumentException("offset must be greater than 0");
        }
        if (orderSource == null) {
            orderSource = Integer.MAX_VALUE;
        }
        if (Integer.MIN_VALUE + offset > orderSource) {
            return Integer.MIN_VALUE;
        }
        return orderSource - offset;
    }
}

