/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid.mysql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.sqlparser.JoinRecognizer;
import io.seata.sqlparser.ParametersHolder;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.SQLUpdateRecognizer;
import io.seata.sqlparser.druid.BaseRecognizer;
import io.seata.sqlparser.druid.mysql.BaseMySQLRecognizer;
import io.seata.sqlparser.util.ColumnUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MySQLUpdateRecognizer
extends BaseMySQLRecognizer
implements SQLUpdateRecognizer,
JoinRecognizer {
    private final MySqlUpdateStatement ast;
    private final Map<String, String> tableName2AliasMap = new HashMap<String, String>(4);

    public MySQLUpdateRecognizer(String originalSQL, SQLStatement ast) {
        super(originalSQL);
        this.ast = (MySqlUpdateStatement)ast;
    }

    @Override
    public SQLType getSQLType() {
        SQLTableSource tableSource = this.ast.getTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            return SQLType.UPDATE;
        }
        if (tableSource instanceof SQLJoinTableSource) {
            return SQLType.UPDATE_JOIN;
        }
        throw new NotSupportYetException("not support update table source with unknow");
    }

    @Override
    public List<String> getUpdateColumns() {
        List updateSetItems = this.ast.getItems();
        ArrayList<String> list = new ArrayList<String>(updateSetItems.size());
        for (SQLUpdateSetItem updateSetItem : updateSetItems) {
            SQLExpr expr = updateSetItem.getColumn();
            if (expr instanceof SQLIdentifierExpr) {
                list.add(((SQLIdentifierExpr)expr).getName());
                continue;
            }
            if (expr instanceof SQLPropertyExpr) {
                SQLExpr owner = ((SQLPropertyExpr)expr).getOwner();
                if (owner instanceof SQLIdentifierExpr) {
                    list.add(((SQLIdentifierExpr)owner).getName() + "." + ((SQLPropertyExpr)expr).getName());
                    continue;
                }
                if (((SQLPropertyExpr)expr).getOwnerName().split("\\.").length <= 1) continue;
                list.add(((SQLPropertyExpr)expr).getOwnerName() + "." + ((SQLPropertyExpr)expr).getName());
                continue;
            }
            this.wrapSQLParsingException(expr);
        }
        return list;
    }

    @Override
    public List<Object> getUpdateValues() {
        List updateSetItems = this.ast.getItems();
        ArrayList<Object> list = new ArrayList<Object>(updateSetItems.size());
        for (SQLUpdateSetItem updateSetItem : updateSetItems) {
            SQLExpr expr = updateSetItem.getValue();
            if (expr instanceof SQLValuableExpr) {
                list.add(((SQLValuableExpr)expr).getValue());
                continue;
            }
            if (expr instanceof SQLVariantRefExpr) {
                list.add(new BaseRecognizer.VMarker());
                continue;
            }
            this.wrapSQLParsingException(expr);
        }
        return list;
    }

    @Override
    public List<String> getUpdateColumnsUnEscape() {
        List<String> updateColumns = this.getUpdateColumns();
        return ColumnUtils.delEscape(updateColumns, this.getDbType());
    }

    @Override
    public String getWhereCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        SQLExpr where = this.ast.getWhere();
        return super.getWhereCondition(where, parametersHolder, paramAppenderList);
    }

    @Override
    public String getWhereCondition() {
        SQLExpr where = this.ast.getWhere();
        return super.getWhereCondition(where);
    }

    @Override
    public String getTableAlias() {
        return this.ast.getTableSource().getAlias();
    }

    @Override
    public String getTableName() {
        SQLTableSource tableSource = this.ast.getTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            return this.visitTableName((SQLExprTableSource)tableSource);
        }
        if (tableSource instanceof SQLJoinTableSource) {
            int minTableNum = 2;
            StringBuilder joinTables = new StringBuilder();
            joinTables.append(tableSource.toString());
            this.tableName2AliasMap.put(tableSource.toString(), tableSource.getAlias());
            this.getTableNames(tableSource, joinTables);
            if (joinTables.toString().split("#").length < 3) {
                throw new ShouldNeverHappenException("should get at least two table name for update join table source:" + tableSource.toString());
            }
            return joinTables.toString();
        }
        throw new NotSupportYetException("not support the syntax of update with unknow");
    }

    @Override
    public String getTableAlias(String tableName) {
        return this.tableName2AliasMap.get(tableName);
    }

    @Override
    public String getLimitCondition() {
        SQLLimit limit = this.ast.getLimit();
        return super.getLimitCondition(limit);
    }

    @Override
    public String getLimitCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        SQLLimit limit = this.ast.getLimit();
        return super.getLimitCondition(limit, parametersHolder, paramAppenderList);
    }

    @Override
    public String getOrderByCondition() {
        SQLOrderBy sqlOrderBy = this.ast.getOrderBy();
        return super.getOrderByCondition(sqlOrderBy);
    }

    @Override
    public String getOrderByCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        SQLOrderBy sqlOrderBy = this.ast.getOrderBy();
        return super.getOrderByCondition(sqlOrderBy, parametersHolder, paramAppenderList);
    }

    @Override
    public String getJoinCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (!(this.ast.getTableSource() instanceof SQLJoinTableSource)) {
            return "";
        }
        SQLExpr joinCondition = ((SQLJoinTableSource)this.ast.getTableSource()).getCondition();
        return super.getJoinCondition(joinCondition, parametersHolder, paramAppenderList);
    }

    @Override
    protected SQLStatement getAst() {
        return this.ast;
    }

    private void getTableNames(SQLTableSource tableSource, StringBuilder tableNames) {
        if (tableSource instanceof SQLJoinTableSource) {
            SQLTableSource left = ((SQLJoinTableSource)tableSource).getLeft();
            if (left instanceof SQLJoinTableSource) {
                this.getTableNames(left, tableNames);
            } else {
                tableNames.append("#");
                String tableName = this.visitTableName((SQLExprTableSource)left);
                tableNames.append(tableName);
                this.tableName2AliasMap.put(tableName, left.getAlias());
            }
            SQLTableSource right = ((SQLJoinTableSource)tableSource).getRight();
            if (right instanceof SQLJoinTableSource) {
                this.getTableNames(right, tableNames);
            } else {
                tableNames.append("#");
                String tableName = this.visitTableName((SQLExprTableSource)right);
                tableNames.append(tableName);
                this.tableName2AliasMap.put(tableName, right.getAlias());
            }
        } else {
            tableNames.append("#");
            String tableName = this.visitTableName((SQLExprTableSource)tableSource);
            tableNames.append(tableName);
            this.tableName2AliasMap.put(tableName, tableSource.getAlias());
        }
    }

    private String visitTableName(SQLExprTableSource tableSource) {
        StringBuilder tableName = new StringBuilder();
        MySqlOutputVisitor visitor = new MySqlOutputVisitor(tableName){

            public boolean visit(SQLExprTableSource x) {
                this.printTableSourceExpr(x.getExpr());
                return false;
            }
        };
        visitor.visit(tableSource);
        return tableName.toString();
    }
}

