/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.registry.compact;

import io.seata.common.loader.LoadLevel;
import io.seata.metrics.Counter;
import io.seata.metrics.Gauge;
import io.seata.metrics.Id;
import io.seata.metrics.Measurement;
import io.seata.metrics.Meter;
import io.seata.metrics.Summary;
import io.seata.metrics.Timer;
import io.seata.metrics.registry.Registry;
import io.seata.metrics.registry.compact.CompactCounter;
import io.seata.metrics.registry.compact.CompactGauge;
import io.seata.metrics.registry.compact.CompactSummary;
import io.seata.metrics.registry.compact.CompactTimer;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@LoadLevel(name="Compact", order=1)
public class CompactRegistry
implements Registry {
    private static final Map<UUID, Meter> METERS = new ConcurrentHashMap<UUID, Meter>();

    public <T extends Number> Gauge<T> getGauge(Id id, Supplier<T> supplier) {
        return (Gauge)METERS.computeIfAbsent(id.getId(), key -> new CompactGauge(id, supplier));
    }

    public Counter getCounter(Id id) {
        return (Counter)METERS.computeIfAbsent(id.getId(), key -> new CompactCounter(id));
    }

    public Summary getSummary(Id id) {
        return (Summary)METERS.computeIfAbsent(id.getId(), key -> new CompactSummary(id));
    }

    public Timer getTimer(Id id) {
        return (Timer)METERS.computeIfAbsent(id.getId(), key -> new CompactTimer(id));
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        if (METERS.size() == 0) {
            return measurements;
        }
        METERS.values().iterator().forEachRemaining(meter -> meter.measure().forEach(measurements::add));
        return measurements;
    }
}

