/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.engine;

import io.servicecomb.foundation.common.utils.BeanUtils;
import io.servicecomb.foundation.common.utils.ReflectUtils;
import io.servicecomb.swagger.engine.SwaggerConsumer;
import io.servicecomb.swagger.engine.SwaggerConsumerOperation;
import io.servicecomb.swagger.engine.SwaggerProducer;
import io.servicecomb.swagger.engine.SwaggerProducerOperation;
import io.servicecomb.swagger.generator.core.SwaggerGenerator;
import io.servicecomb.swagger.generator.core.unittest.UnitTestSwaggerUtils;
import io.servicecomb.swagger.generator.core.utils.ClassUtils;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapper;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapperFactory;
import io.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import io.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapperFactory;
import io.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapper;
import io.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapperFactory;
import io.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;
import io.servicecomb.swagger.invocation.response.producer.ProducerResponseMapperFactory;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.Swagger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class SwaggerEnvironment {
    @Inject
    private ProducerArgumentsMapperFactory producerArgumentsFactory;
    @Inject
    private ProducerResponseMapperFactory producerResponseMapperFactory;
    @Inject
    private ConsumerArgumentsMapperFactory consumerArgumentsFactory;
    @Inject
    private ConsumerResponseMapperFactory consumerResponseMapperFactory;

    public ProducerArgumentsMapperFactory getProducerArgumentsFactory() {
        return this.producerArgumentsFactory;
    }

    public void setProducerArgumentsFactory(ProducerArgumentsMapperFactory producerArgumentsFactory) {
        this.producerArgumentsFactory = producerArgumentsFactory;
    }

    public ProducerResponseMapperFactory getProducerResponseMapperFactory() {
        return this.producerResponseMapperFactory;
    }

    public void setProducerResponseMapperFactory(ProducerResponseMapperFactory producerResponseMapperFactory) {
        this.producerResponseMapperFactory = producerResponseMapperFactory;
    }

    public ConsumerArgumentsMapperFactory getConsumerArgumentsFactory() {
        return this.consumerArgumentsFactory;
    }

    public void setConsumerArgumentsFactory(ConsumerArgumentsMapperFactory consumerArgumentsFactory) {
        this.consumerArgumentsFactory = consumerArgumentsFactory;
    }

    public ConsumerResponseMapperFactory getConsumerResponseMapperFactory() {
        return this.consumerResponseMapperFactory;
    }

    public void setConsumerResponseMapperFactory(ConsumerResponseMapperFactory consumerResponseMapperFactory) {
        this.consumerResponseMapperFactory = consumerResponseMapperFactory;
    }

    public SwaggerConsumer createConsumer(Class<?> consumerIntf) {
        return this.createConsumer(consumerIntf, consumerIntf);
    }

    public SwaggerConsumer createConsumer(Class<?> consumerIntf, Class<?> swaggerIntf) {
        SwaggerConsumer consumer = new SwaggerConsumer();
        consumer.setConsumerIntf(consumerIntf);
        consumer.setSwaggerIntf(swaggerIntf);
        for (Method consumerMethod : consumerIntf.getMethods()) {
            String methodName = consumerMethod.getName();
            Method swaggerMethod = ReflectUtils.findMethod(swaggerIntf, (String)methodName);
            if (swaggerMethod == null) {
                String msg = String.format("consumer method %s:%s not exist in swagger.", consumerIntf.getName(), consumerMethod.getName());
                throw new Error(msg);
            }
            ConsumerArgumentsMapper argsMapper = (ConsumerArgumentsMapper)this.consumerArgumentsFactory.createArgumentsMapper(swaggerMethod, consumerMethod);
            ConsumerResponseMapper responseMapper = (ConsumerResponseMapper)this.consumerResponseMapperFactory.createResponseMapper(swaggerMethod.getGenericReturnType(), consumerMethod.getGenericReturnType());
            SwaggerConsumerOperation op = new SwaggerConsumerOperation();
            op.setName(methodName);
            op.setConsumerMethod(consumerMethod);
            op.setSwaggerMethod(swaggerMethod);
            op.setArgumentsMapper(argsMapper);
            op.setResponseMapper(responseMapper);
            consumer.addOperation(op);
        }
        return consumer;
    }

    public SwaggerProducer createProducer(Object producerInstance, Swagger swagger) {
        Class producerCls = BeanUtils.getImplClassFromBean((Object)producerInstance);
        Map<String, Method> visibleProducerMethods = this.retrieveVisibleMethods(producerCls);
        Class swaggerIntf = ClassUtils.getOrCreateInterface((Swagger)swagger, null, null);
        SwaggerProducer producer = new SwaggerProducer();
        producer.setProducerCls(producerCls);
        producer.setSwaggerIntf(swaggerIntf);
        for (Method swaggerMethod : swaggerIntf.getMethods()) {
            String methodName = swaggerMethod.getName();
            Method producerMethod = visibleProducerMethods.getOrDefault(methodName, null);
            if (producerMethod == null) {
                String msg = String.format("swagger method %s:%s not exist in producer.", swaggerIntf.getClass().getName(), methodName);
                throw new Error(msg);
            }
            ProducerArgumentsMapper argsMapper = (ProducerArgumentsMapper)this.producerArgumentsFactory.createArgumentsMapper(swaggerMethod, producerMethod);
            ProducerResponseMapper responseMapper = (ProducerResponseMapper)this.producerResponseMapperFactory.createResponseMapper(producerMethod.getGenericReturnType(), swaggerMethod.getGenericReturnType());
            SwaggerProducerOperation op = new SwaggerProducerOperation();
            op.setName(methodName);
            op.setProducerClass(producerCls);
            op.setProducerInstance(producerInstance);
            op.setProducerMethod(producerMethod);
            op.setSwaggerMethod(swaggerMethod);
            op.setArgumentsMapper(argsMapper);
            op.setResponseMapper(responseMapper);
            producer.addOperation(op);
        }
        return producer;
    }

    public SwaggerProducer createProducer(Object producerInstance) {
        Class producerCls = BeanUtils.getImplClassFromBean((Object)producerInstance);
        SwaggerGenerator producerGenerator = UnitTestSwaggerUtils.generateSwagger((Class)producerCls);
        Swagger swagger = producerGenerator.getSwagger();
        return this.createProducer(producerInstance, swagger);
    }

    private Map<String, Method> retrieveVisibleMethods(Class<?> clazz) {
        HashMap<String, Method> visibleMethods = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(ApiOperation.class) && method.getAnnotation(ApiOperation.class).hidden()) continue;
            visibleMethods.put(method.getName(), method);
        }
        return visibleMethods;
    }
}

