/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.engine;

import io.servicecomb.swagger.invocation.AsyncResponse;
import io.servicecomb.swagger.invocation.Response;
import io.servicecomb.swagger.invocation.SwaggerInvocation;
import io.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import io.servicecomb.swagger.invocation.context.ContextUtils;
import io.servicecomb.swagger.invocation.exception.InvocationException;
import io.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerProducerOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerProducerOperation.class);
    private String name;
    private Class<?> producerClass;
    private Object producerInstance;
    private Method producerMethod;
    private Method swaggerMethod;
    private ProducerArgumentsMapper argumentsMapper;
    private ProducerResponseMapper responseMapper;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getProducerClass() {
        return this.producerClass;
    }

    public void setProducerClass(Class<?> producerClass) {
        this.producerClass = producerClass;
    }

    public Object getProducerInstance() {
        return this.producerInstance;
    }

    public void setProducerInstance(Object producerInstance) {
        this.producerInstance = producerInstance;
    }

    public Method getProducerMethod() {
        return this.producerMethod;
    }

    public void setProducerMethod(Method producerMethod) {
        this.producerMethod = producerMethod;
    }

    public Method getSwaggerMethod() {
        return this.swaggerMethod;
    }

    public void setSwaggerMethod(Method swaggerMethod) {
        this.swaggerMethod = swaggerMethod;
    }

    public ProducerArgumentsMapper getArgumentsMapper() {
        return this.argumentsMapper;
    }

    public void setArgumentsMapper(ProducerArgumentsMapper argumentsMapper) {
        this.argumentsMapper = argumentsMapper;
    }

    public ProducerResponseMapper getResponseMapper() {
        return this.responseMapper;
    }

    public void setResponseMapper(ProducerResponseMapper responseMapper) {
        this.responseMapper = responseMapper;
    }

    public void invoke(SwaggerInvocation invocation, AsyncResponse asyncResp) {
        ContextUtils.setInvocationContext(invocation);
        Response response = this.doInvoke(invocation);
        ContextUtils.removeInvocationContext();
        asyncResp.handle(response);
    }

    public Response doInvoke(SwaggerInvocation invocation) {
        Response response = null;
        try {
            Object[] args = this.argumentsMapper.toProducerArgs(invocation);
            Object result = this.producerMethod.invoke(this.producerInstance, args);
            response = this.responseMapper.mapResponse(invocation.getStatus(), result);
        }
        catch (Throwable e) {
            response = this.processException(e);
        }
        return response;
    }

    protected Response processException(Throwable e) {
        if (InvocationTargetException.class.isInstance(e)) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (InvocationException.class.isInstance(e)) {
            return Response.failResp((InvocationException)e);
        }
        Response response = Response.producerFailResp(e);
        String msg = String.format("Producer invoke failed, %s:%s", this.producerClass.getName(), this.producerMethod.getName());
        LOGGER.error(msg, e);
        return response;
    }
}

