/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.arguments.consumer;

import io.servicecomb.swagger.invocation.SwaggerInvocation;
import io.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import io.servicecomb.swagger.invocation.arguments.FieldInfo;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConsumerArgumentToBodyField
implements ArgumentMapper {
    private Class<?> swaggerParamType;
    private Map<Integer, FieldInfo> fieldMap;

    public ConsumerArgumentToBodyField(Class<?> swaggerParamType, Map<Integer, FieldInfo> fieldMap) {
        this.swaggerParamType = this.correctType(swaggerParamType);
        this.fieldMap = fieldMap;
    }

    protected Class<?> correctType(Class<?> swaggerParamType) {
        if (!Modifier.isAbstract(swaggerParamType.getModifiers())) {
            return swaggerParamType;
        }
        if (List.class.isAssignableFrom(swaggerParamType)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(swaggerParamType)) {
            return HashSet.class;
        }
        throw new Error("not support " + swaggerParamType.getName());
    }

    public Class<?> getSwaggerParamType() {
        return this.swaggerParamType;
    }

    @Override
    public void mapArgument(SwaggerInvocation invocation, Object[] consumerArguments) {
        try {
            Object body = this.swaggerParamType.newInstance();
            for (Map.Entry<Integer, FieldInfo> entry : this.fieldMap.entrySet()) {
                FieldInfo info = entry.getValue();
                Object consumerParam = consumerArguments[entry.getKey()];
                Object swaggerParam = info.getConverter().convert(consumerParam);
                info.getField().set(body, swaggerParam);
            }
            invocation.setSwaggerArgument(0, body);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }
}

