/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.context;

import io.servicecomb.swagger.invocation.context.HttpStatus;
import io.servicecomb.swagger.invocation.context.HttpStatusManager;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public class InvocationContext {
    private static HttpStatusManager statusMgr = new HttpStatusManager();
    protected Response.StatusType httpStatus;
    protected Map<String, String> context = new HashMap<String, String>();

    public InvocationContext() {
        this.httpStatus = Response.Status.OK;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void addContext(String key, String value) {
        this.context.put(key, value);
    }

    public <T> T getContext(String key) {
        return (T)this.context.get(key);
    }

    public void addContext(InvocationContext otherContext) {
        this.addContext(otherContext.getContext());
    }

    public void addContext(Map<String, String> otherContext) {
        if (otherContext == null) {
            return;
        }
        this.context.putAll(otherContext);
    }

    public Response.StatusType getStatus() {
        return this.httpStatus;
    }

    public void setStatus(Response.StatusType status) {
        this.httpStatus = status;
    }

    public void setStatus(int statusCode, String reason) {
        this.httpStatus = new HttpStatus(statusCode, reason);
    }

    public void setStatus(int statusCode) {
        this.httpStatus = statusMgr.getOrCreateByStatusCode(statusCode);
    }
}

