/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.exception;

import io.servicecomb.swagger.invocation.context.HttpStatus;
import io.servicecomb.swagger.invocation.exception.CommonExceptionData;
import io.servicecomb.swagger.invocation.exception.InvocationException;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.core.Response;

public final class ExceptionFactory {
    public static final int PRODUCER_INNER_STATUS_CODE = 590;
    public static final String PRODUCER_INNER_REASON_PHRASE = "Cse Internal Server Error";
    public static final Response.StatusType PRODUCER_INNER_STATUS = new HttpStatus(590, "Cse Internal Server Error");
    public static final int CONSUMER_INNER_STATUS_CODE = 490;
    public static final String CONSUMER_INNER_REASON_PHRASE = "Cse Internal Bad Request";
    public static final Response.StatusType CONSUMER_INNER_STATUS = new HttpStatus(490, "Cse Internal Bad Request");

    private ExceptionFactory() {
    }

    public static InvocationException create(Response.StatusType status, Object exceptionOrErrorData) {
        if (InvocationException.class.isInstance(exceptionOrErrorData)) {
            return (InvocationException)exceptionOrErrorData;
        }
        return ExceptionFactory.doCreate(status, exceptionOrErrorData);
    }

    public static InvocationException createConsumerException(Object errorData) {
        return ExceptionFactory.create(CONSUMER_INNER_STATUS, errorData);
    }

    public static InvocationException createProducerException(Object errorData) {
        return ExceptionFactory.create(PRODUCER_INNER_STATUS, errorData);
    }

    protected static InvocationException doCreate(Response.StatusType status, Object errorData) {
        return new InvocationException(status, errorData);
    }

    protected static InvocationException doCreate(int statusCode, String reasonPhrase, CommonExceptionData data, Throwable e) {
        return new InvocationException(statusCode, reasonPhrase, data, e);
    }

    public static InvocationException convertConsumerException(Throwable e) {
        return ExceptionFactory.convertException(490, CONSUMER_INNER_REASON_PHRASE, e, CONSUMER_INNER_REASON_PHRASE);
    }

    public static InvocationException convertConsumerException(Throwable e, String errorMsg) {
        return ExceptionFactory.convertException(490, CONSUMER_INNER_REASON_PHRASE, e, errorMsg);
    }

    public static InvocationException convertProducerException(Throwable e) {
        return ExceptionFactory.convertException(590, PRODUCER_INNER_REASON_PHRASE, e, PRODUCER_INNER_REASON_PHRASE);
    }

    public static InvocationException convertProducerException(Throwable e, String errorMsg) {
        return ExceptionFactory.convertException(590, PRODUCER_INNER_REASON_PHRASE, e, errorMsg);
    }

    protected static InvocationException convertException(int statusCode, String reasonPhrase, Throwable e, String errorMsg) {
        if (InvocationTargetException.class.isInstance(e)) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (InvocationException.class.isInstance(e)) {
            return (InvocationException)e;
        }
        CommonExceptionData data = new CommonExceptionData(errorMsg);
        return ExceptionFactory.doCreate(statusCode, reasonPhrase, data, e);
    }
}

