/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.response;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.servicecomb.swagger.invocation.context.HttpStatus;
import io.servicecomb.swagger.invocation.exception.CommonExceptionData;
import io.servicecomb.swagger.invocation.response.ResponseMeta;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public class ResponsesMeta {
    private static final JavaType COMMON_EXCEPTION_JAVATYPE = SimpleType.constructUnsafe(CommonExceptionData.class);
    private Map<Integer, ResponseMeta> responseMap = new HashMap<Integer, ResponseMeta>();
    private ResponseMeta defaultResponse;

    public void init(ClassLoader classLoader, String packageName, Swagger swagger, Operation operation, Type returnType) {
        this.initSuccessResponse(returnType);
        for (Map.Entry entry : operation.getResponses().entrySet()) {
            if ("default".equals(entry.getKey())) {
                this.defaultResponse = new ResponseMeta();
                this.defaultResponse.init(classLoader, packageName, swagger, (Response)entry.getValue());
                continue;
            }
            Integer statusCode = Integer.parseInt((String)entry.getKey());
            ResponseMeta responseMeta = this.responseMap.get(statusCode);
            if (responseMeta == null) {
                responseMeta = new ResponseMeta();
                this.responseMap.put(statusCode, responseMeta);
            }
            responseMeta.init(classLoader, packageName, swagger, (Response)entry.getValue());
        }
        if (this.defaultResponse == null) {
            ResponseMeta responseMeta = new ResponseMeta();
            responseMeta.setJavaType(COMMON_EXCEPTION_JAVATYPE);
            this.defaultResponse = responseMeta;
        }
    }

    protected void initSuccessResponse(Type returnType) {
        ResponseMeta successResponse = new ResponseMeta();
        successResponse.setJavaType(TypeFactory.defaultInstance().constructType(returnType));
        this.responseMap.put(Response.Status.OK.getStatusCode(), successResponse);
    }

    public ResponseMeta findResponseMeta(int statusCode) {
        ResponseMeta responseMeta = this.responseMap.get(statusCode);
        if (responseMeta == null) {
            if (HttpStatus.isSuccess((int)statusCode)) {
                return this.responseMap.get(Response.Status.OK.getStatusCode());
            }
            return this.defaultResponse;
        }
        return responseMeta;
    }
}

