/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.merger.pagination;

import io.shardingjdbc.core.merger.ResultSetMerger;
import io.shardingjdbc.core.merger.common.AbstractDecoratorResultSetMerger;
import io.shardingjdbc.core.parsing.parser.context.limit.Limit;
import java.sql.SQLException;

public final class TopAndRowNumberDecoratorResultSetMerger
extends AbstractDecoratorResultSetMerger {
    private final Limit limit;
    private final boolean skipAll;
    private int rowNumber;

    public TopAndRowNumberDecoratorResultSetMerger(ResultSetMerger resultSetMerger, Limit limit) throws SQLException {
        super(resultSetMerger);
        this.limit = limit;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        int end = null == this.limit.getOffset() ? 0 : (this.limit.getOffset().isBoundOpened() ? this.limit.getOffsetValue() - 1 : this.limit.getOffsetValue());
        for (int i = 0; i < end; ++i) {
            if (this.getResultSetMerger().next()) continue;
            return true;
        }
        this.rowNumber = end + 1;
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (this.limit.getRowCountValue() < 0) {
            return this.getResultSetMerger().next();
        }
        return this.rowNumber++ <= this.limit.getRowCountValue() && this.getResultSetMerger().next();
    }
}

