/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.Assist;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.context.condition.Column;
import io.shardingjdbc.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.util.SQLUtil;
import java.beans.ConstructorProperties;
import java.util.LinkedList;

public final class InsertColumnsClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;

    public void parse(InsertStatement insertStatement) {
        LinkedList<Column> result = new LinkedList<Column>();
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            String tableName = insertStatement.getTables().getSingleTableName();
            Optional<String> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
            int count = 0;
            do {
                this.lexerEngine.nextToken();
                String columnName = SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals());
                result.add(new Column(columnName, tableName));
                this.lexerEngine.nextToken();
                if (generateKeyColumn.isPresent() && ((String)generateKeyColumn.get()).equalsIgnoreCase(columnName)) {
                    insertStatement.setGenerateKeyColumnIndex(count);
                }
                ++count;
            } while (!this.lexerEngine.equalAny(Symbol.RIGHT_PAREN) && !this.lexerEngine.equalAny(Assist.END));
            insertStatement.setColumnsListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
            this.lexerEngine.nextToken();
        }
        insertStatement.getColumns().addAll(result);
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine"})
    public InsertColumnsClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
    }
}

