/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingjdbc.core.parsing.parser.sql.dml.insert.InsertStatement;
import java.beans.ConstructorProperties;

public class InsertIntoClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public void parse(InsertStatement insertStatement) {
        this.lexerEngine.unsupportedIfEqual(this.getUnsupportedKeywordsBeforeInto());
        this.lexerEngine.skipUntil(DefaultKeyword.INTO);
        this.lexerEngine.nextToken();
        this.tableReferencesClauseParser.parse(insertStatement, true);
        this.skipBetweenTableAndValues(insertStatement);
    }

    protected Keyword[] getUnsupportedKeywordsBeforeInto() {
        return new Keyword[0];
    }

    private void skipBetweenTableAndValues(InsertStatement insertStatement) {
        while (this.lexerEngine.skipIfEqual(this.getSkippedKeywordsBetweenTableAndValues())) {
            this.lexerEngine.nextToken();
            if (!this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) continue;
            this.lexerEngine.skipParentheses(insertStatement);
        }
    }

    protected Keyword[] getSkippedKeywordsBetweenTableAndValues() {
        return new Keyword[0];
    }

    @ConstructorProperties(value={"lexerEngine", "tableReferencesClauseParser"})
    public InsertIntoClauseParser(LexerEngine lexerEngine, TableReferencesClauseParser tableReferencesClauseParser) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = tableReferencesClauseParser;
    }
}

