/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.dialect.sqlserver.clause;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.dialect.sqlserver.SQLServerKeyword;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.OrderByClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.SelectListClauseParser;
import io.shardingjdbc.core.parsing.parser.context.selectitem.CommonSelectItem;
import io.shardingjdbc.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingjdbc.core.parsing.parser.dialect.sqlserver.clause.SQLServerOrderByClauseParser;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.rule.ShardingRule;

public final class SQLServerSelectListClauseParser
extends SelectListClauseParser {
    private OrderByClauseParser orderByClauseParser;

    public SQLServerSelectListClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine);
        this.orderByClauseParser = new SQLServerOrderByClauseParser(lexerEngine);
    }

    @Override
    protected boolean isRowNumberSelectItem() {
        return this.getLexerEngine().skipIfEqual(SQLServerKeyword.ROW_NUMBER);
    }

    @Override
    protected SelectItem parseRowNumberSelectItem(SelectStatement selectStatement) {
        this.getLexerEngine().skipParentheses(selectStatement);
        this.getLexerEngine().accept(DefaultKeyword.OVER);
        this.getLexerEngine().accept(Symbol.LEFT_PAREN);
        this.getLexerEngine().unsupportedIfEqual(SQLServerKeyword.PARTITION);
        this.orderByClauseParser.parse(selectStatement);
        this.getLexerEngine().accept(Symbol.RIGHT_PAREN);
        return new CommonSelectItem(SQLServerKeyword.ROW_NUMBER.name(), this.getAliasExpressionParser().parseSelectItemAlias());
    }
}

