/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.type.hint;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.algorithm.sharding.ShardingValue;
import io.shardingjdbc.core.hint.HintManagerHolder;
import io.shardingjdbc.core.hint.ShardingKey;
import io.shardingjdbc.core.routing.strategy.hint.HintShardingStrategy;
import io.shardingjdbc.core.routing.type.RoutingEngine;
import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.TableUnit;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseHintRoutingEngine
implements RoutingEngine {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHintRoutingEngine.class);
    private final Map<String, DataSource> dataSourceMap;
    private final HintShardingStrategy databaseShardingStrategy;

    @Override
    public RoutingResult route() {
        Optional<ShardingValue> shardingValue = HintManagerHolder.getDatabaseShardingValue(new ShardingKey("DB_TABLE_NAME", "DB_COLUMN_NAME"));
        Preconditions.checkState((boolean)shardingValue.isPresent());
        log.debug("Before database sharding only db:{} sharding values: {}", this.dataSourceMap.keySet(), shardingValue.get());
        Collection<String> routingDataSources = this.databaseShardingStrategy.doSharding(this.dataSourceMap.keySet(), Collections.singletonList(shardingValue.get()));
        Preconditions.checkState((!routingDataSources.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        log.debug("After database sharding only result: {}", routingDataSources);
        RoutingResult result = new RoutingResult();
        for (String each : routingDataSources) {
            result.getTableUnits().getTableUnits().add(new TableUnit(each, "", ""));
        }
        return result;
    }

    @ConstructorProperties(value={"dataSourceMap", "databaseShardingStrategy"})
    public DatabaseHintRoutingEngine(Map<String, DataSource> dataSourceMap, HintShardingStrategy databaseShardingStrategy) {
        this.dataSourceMap = dataSourceMap;
        this.databaseShardingStrategy = databaseShardingStrategy;
    }
}

